/* Filename: Indication.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: May 7, 2010
 */
package nil.ucm.indications2.core.rep.indication;

import java.util.Collection;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.Data;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.ImmutableHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class Indication implements IIndication {
	
	private final IDesc refexp;
	private final IHasPositionSet<IConstituent> cons;
	private final IHasPositionSet<INucleus> nucs;
	private final IHasPositionSet<IModifier> mods;
	
	public Indication(IDesc refexp, Collection<? extends IConstituentBuilder> constituents){
		if(refexp == null)
			throw new NullPointerException();
		if(!RefExpRep.getInstance().isType(refexp))
			throw new IllegalArgumentException();
		
		IHasPositionSet<IConstituent> hiddenCons = new HasPositionSet<IConstituent>();
		IHasPositionSet<INucleus> hiddenNucs = new HasPositionSet<INucleus>();
		IHasPositionSet<IModifier> hiddenMods = new HasPositionSet<IModifier>();
		IConstituent c;
		for(IConstituentBuilder builder : constituents){
			c = builder.toConstituent(this);
			hiddenCons.add(c);
			if(c instanceof INucleus){
				hiddenNucs.add((INucleus)c);
			} else if(c instanceof IModifier){
				hiddenMods.add((IModifier)c);
			} else {
				throw new IllegalArgumentException();
			}
		}
		if(hiddenCons.isEmpty())
			throw new IllegalArgumentException();
		if(hiddenNucs.isEmpty())
			throw new IllegalArgumentException();
		
		// final assignments
		this.refexp = refexp;
		this.cons = new ImmutableHasPositionSet<IConstituent>(hiddenCons);
		this.nucs = new ImmutableHasPositionSet<INucleus>(hiddenNucs);
		this.mods = new ImmutableHasPositionSet<IModifier>(hiddenMods);
		
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition()
	 */
	public IHasPosition calculatePosition() {
		return refexp;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IIndication#getConstituents()
	 */
	public IHasPositionSet<IConstituent> getConstituents() {
		return cons;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IIndication#getModifiers()
	 */
	public IHasPositionSet<IModifier> getModifiers() {
		return mods;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IIndication#getNuclei()
	 */
	public IHasPositionSet<INucleus> getNuclei() {
		return nucs;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.IIndication#getReferringExpression()
	 */
	public IDesc getReferringExpression() {
		return refexp;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	public IHasPosition getDisplayPosition() {
		return refexp;
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getLength()
	 */
	public int getLength() {
		return cons.getLength();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getOffset()
	 */
	public int getOffset() {
		return cons.getOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.position.IHasPosition#getRightOffset()
	 */
	public int getRightOffset() {
		return cons.getRightOffset();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel)
	 */
	public IStructuredData recalculate(IDesc container, IStoryModel model) {
		return null;
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		if(this == tgtData)
			return true;
		if(!IIndication.class.isAssignableFrom(tgtData.getClass()))
			return false;
		IIndication tgtInd = (IIndication)tgtData;
		
		if(!refexp.equals(tgtInd.getReferringExpression()))
			return false;
		if(!Data.equals(nucs, tgtInd.getNuclei(), model))
			return false;
		if(!Data.equals(mods, tgtInd.getModifiers(), model))
			return false;
		
		return true;
	}

	/** 
	 * TODO: Write comment
	 *
	 * @author M.A. Finlayson
	 * @version $Rev$, $LastChangedDate$
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public static interface IConstituentBuilder {
		
		public IConstituent toConstituent(IIndication parent);
		
	}
	
	/** 
	 * TODO: Write comment
	 *
	 * @author M.A. Finlayson
	 * @version $Rev$, $LastChangedDate$
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public static class ConstituentBuilder implements IConstituentBuilder {
		
		private final boolean isNucleus;
		private final IndicationType type;
		private final ISegmentSet segments;
		
		public ConstituentBuilder(boolean isNucleus, IndicationType type, ISegmentSet segments){
			if(type == null)
				throw new NullPointerException();
			if(segments.getRep() != TokenRep.getInstance())
				throw new IllegalArgumentException();
			if(segments.isEmpty())
				throw new IllegalArgumentException();
			
			this.isNucleus = isNucleus;
			this.type = type;
			this.segments = segments;
		}

		/* 
		 * (non-Javadoc) @see nil.ucm.indications2.core.rep.indication.Indication.IConstituentDesc#toConstituent(nil.ucm.indications2.core.rep.indication.IIndication)
		 */
		public IConstituent toConstituent(IIndication parent) {
			if(isNucleus){
				return new Nucleus(parent, type, segments);
			} else {
				return new Modifier(parent, type, segments);
			}
		}
		
	}
	
}
