/* Filename: DummyRelation.java
 * Author: M. A. Finlayson
 * Format: Java 2 v1.5.0
 * Date created: Sep 17, 2008
 * 
 * || Insert License Here ||
 */
package edu.mit.discourse.core.rep.relation;

import java.util.List;

import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IProperty;

public class DummyRelation implements IRelation {

	private final ILexicalMarker lexMarker;

	public DummyRelation(ILexicalMarker lexMarker){
		if(lexMarker == null) throw new NullPointerException();
		this.lexMarker = lexMarker;
	}

	/* (non-Javadoc) @see edu.mit.discourse.core.rep.relation.IRelation#getLexicalMarker() */
	public ILexicalMarker getLexicalMarker() {
		return lexMarker;
	}

	/* (non-Javadoc) @see edu.mit.discourse.core.rep.relation.IRelation#getArguments() */
	public List<IArgument> getArguments() {
		return null;
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#getDisplayPosition()
	 */
	
	public IHasPosition getDisplayPosition() {
		return calculatePosition();
	}

	/* (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#calculatePosition() */
	public IHasPosition calculatePosition() {
		return getLexicalMarker().calculatePosition();
	}

	/* (non-Javadoc) @see edu.mit.story.core.desc.IStructuredData#recalculate(edu.mit.story.core.model.IStoryModel) */
	public IStructuredData recalculate(IDesc container, IStoryModel provider) {
		return null;
	}

	/* (non-Javadoc) @see edu.mit.story.core.property.IHasProperties#getProperties() */
	public List<IProperty> getProperties() {
		return null;
	}

	/* (non-Javadoc) @see edu.mit.story.core.util.IHasDisplayText#getDisplayText() */
	public String getDisplayText() {
		return getLexicalMarker().getDisplayText();
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.desc.IData#equals(edu.mit.story.core.desc.IData, edu.mit.story.core.align.IAlignedStoryModel)
	 */
	public boolean equals(IData tgtData, IAlignedStoryModel model) {
		throw new UnsupportedOperationException();
	}

}
