/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    private Filters() {
    }

    public static Filter acceptFilter() {
        return new CategoricalFilter(true);
    }

    public static Filter rejectFilter() {
        return new CategoricalFilter(false);
    }

    public static <E> Filter<E> collectionAcceptFilter(E[] objs) {
        return new CollectionAcceptFilter(Arrays.asList(objs), true);
    }

    public static <E> Filter<E> collectionAcceptFilter(Collection<E> objs) {
        return new CollectionAcceptFilter(objs, true);
    }

    public static <E> Filter collectionRejectFilter(E[] objs) {
        return new CollectionAcceptFilter(Arrays.asList(objs), false);
    }

    public static <E> Filter<E> collectionRejectFilter(Collection<E> objs) {
        return new CollectionAcceptFilter(objs, false);
    }

    public static <E> Filter andFilter(Filter<E> f1, Filter<E> f2) {
        return new CombinedFilter<E>(f1, f2, true);
    }

    public static <E> Filter orFilter(Filter<E> f1, Filter<E> f2) {
        return new CombinedFilter<E>(f1, f2, false);
    }

    public static <E> Filter<E> notFilter(Filter<E> filter) {
        return new NegatedFilter<E>(filter);
    }

    public static <E> Filter<E> switchedFilter(Filter<E> filter, boolean negated) {
        return new NegatedFilter<E>(filter, negated);
    }

    public static <E> Object[] filter(E[] elems, Filter<E> filter) {
        ArrayList<E> filtered = new ArrayList<E>();
        for (int i = 0; i < elems.length; ++i) {
            if (!filter.accept(elems[i])) continue;
            filtered.add(elems[i]);
        }
        return filtered.toArray((Object[])Array.newInstance(elems.getClass().getComponentType(), filtered.size()));
    }

    public static <E> void retainAll(Collection<E> elems, Filter<E> filter) {
        Iterator<E> iter = elems.iterator();
        while (iter.hasNext()) {
            E elem = iter.next();
            if (filter.accept(elem)) continue;
            iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NegatedFilter<E>
    implements Filter<E> {
        private Filter<E> filter;
        private boolean negated;

        public NegatedFilter(Filter<E> filter, boolean negated) {
            this.filter = filter;
            this.negated = negated;
        }

        public NegatedFilter(Filter<E> filter) {
            this(filter, true);
        }

        @Override
        public boolean accept(E o) {
            return this.negated ^ this.filter.accept(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedFilter<E>
    implements Filter<E> {
        private Filter<E> f1;
        private Filter<E> f2;
        private boolean conjunction;

        public CombinedFilter(Filter<E> f1, Filter<E> f2, boolean conjunction) {
            this.f1 = f1;
            this.f2 = f2;
            this.conjunction = conjunction;
        }

        @Override
        public boolean accept(E o) {
            if (this.conjunction) {
                return this.f1.accept(o) && this.f2.accept(o);
            }
            return this.f1.accept(o) || this.f2.accept(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionAcceptFilter<E>
    implements Filter<E>,
    Serializable {
        private final Collection<E> args;
        private final boolean judgment;
        private static final long serialVersionUID = -8870550963937943540L;

        private CollectionAcceptFilter(Collection<E> c, boolean judgment) {
            this.args = new HashSet<E>(c);
            this.judgment = judgment;
        }

        @Override
        public boolean accept(E obj) {
            if (this.args.contains(obj)) {
                return this.judgment;
            }
            return !this.judgment;
        }
    }

    private static final class CategoricalFilter
    implements Filter {
        private final boolean judgment;

        private CategoricalFilter(boolean judgment) {
            this.judgment = judgment;
        }

        public boolean accept(Object obj) {
            return this.judgment;
        }
    }
}

