/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraLabel;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import java.util.HashMap;

public class NegraHeadFinder
extends AbstractCollinsHeadFinder {
    private boolean coordSwitch = false;
    String left;
    String right;

    public static HeadFinder negraSemanticHeadFinder() {
        NegraHeadFinder result = new NegraHeadFinder();
        result.nonTerminalInfo.put("S", new String[][]{{result.right, "VVFIN", "VVIMP"}, {"right", "VP", "CVP"}, {"right", "VMFIN", "VAFIN", "VAIMP"}, {"right", "S", "CS"}});
        result.nonTerminalInfo.put("VP", new String[][]{{"right", "VVINF", "VVIZU", "VVPP"}, {result.right, "VZ", "VAINF", "VMINF", "VMPP", "VAPP", "PP"}});
        result.nonTerminalInfo.put("VZ", new String[][]{{result.right, "VVINF", "VAINF", "VMINF", "VVFIN", "VVIZU"}});
        return result;
    }

    public NegraHeadFinder() {
        this(new NegraPennLanguagePack());
    }

    public NegraHeadFinder(TreebankLanguagePack tlp) {
        super(tlp);
        this.nonTerminalInfo = new HashMap();
        this.left = this.coordSwitch ? "right" : "left";
        this.right = this.coordSwitch ? "left" : "right";
        this.nonTerminalInfo.put("S", new String[][]{{this.left, "PRELS"}});
        this.nonTerminalInfo.put("NUR", new String[][]{{this.left, "S"}});
        this.nonTerminalInfo.put("ROOT", new String[][]{{this.left, "S", "CS", "VP", "CVP", "NP", "XY", "CNP", "AVP", "CAVP"}});
        this.nonTerminalInfo.put("NP", new String[][]{{this.right, "NN", "NE", "MPN", "NP", "CNP", "PN", "CAR"}});
        this.nonTerminalInfo.put("AP", new String[][]{{this.right, "ADJD", "ADJA", "CAP", "AA", "ADV"}});
        this.nonTerminalInfo.put("PP", new String[][]{{this.left, "KOKOM", "APPR", "PROAV"}});
        this.nonTerminalInfo.put("S", new String[][]{{this.right, "VMFIN", "VVFIN", "VAFIN", "VVIMP", "VAIMP"}, {"right", "VP", "CVP"}, {"right", "S", "CS"}});
        this.nonTerminalInfo.put("VP", new String[][]{{this.right, "VZ", "VAINF", "VMINF", "VVINF", "VVIZU", "VVPP", "VMPP", "VAPP", "PP"}});
        this.nonTerminalInfo.put("VZ", new String[][]{{this.left, "PRTZU", "APPR", "PTKZU"}});
        this.nonTerminalInfo.put("CO", new String[][]{{this.left}});
        this.nonTerminalInfo.put("AVP", new String[][]{{this.right, "ADV", "AVP", "ADJD", "PROAV", "PP"}});
        this.nonTerminalInfo.put("AA", new String[][]{{this.right, "ADJD", "ADJA"}});
        this.nonTerminalInfo.put("CNP", new String[][]{{this.right, "NN", "NE", "MPN", "NP", "CNP", "PN", "CAR"}});
        this.nonTerminalInfo.put("CAP", new String[][]{{this.right, "ADJD", "ADJA", "CAP", "AA", "ADV"}});
        this.nonTerminalInfo.put("CPP", new String[][]{{this.right, "APPR", "PROAV", "PP", "CPP"}});
        this.nonTerminalInfo.put("CS", new String[][]{{this.right, "S", "CS"}});
        this.nonTerminalInfo.put("CVP", new String[][]{{this.right, "VP", "CVP"}});
        this.nonTerminalInfo.put("CVZ", new String[][]{{this.right, "VZ"}});
        this.nonTerminalInfo.put("CAVP", new String[][]{{this.right, "ADV", "AVP", "ADJD", "PWAV", "APPR", "PTKVZ"}});
        this.nonTerminalInfo.put("MPN", new String[][]{{this.right, "NE", "FM", "CARD"}});
        this.nonTerminalInfo.put("NM", new String[][]{{this.right, "CARD", "NN"}});
        this.nonTerminalInfo.put("CAC", new String[][]{{this.right, "APPR", "AVP"}});
        this.nonTerminalInfo.put("CH", new String[][]{{this.right}});
        this.nonTerminalInfo.put("MTA", new String[][]{{this.right, "ADJA", "ADJD", "NN"}});
        this.nonTerminalInfo.put("CCP", new String[][]{{this.right, "AVP"}});
        this.nonTerminalInfo.put("DL", new String[][]{{this.left}});
        this.nonTerminalInfo.put("ISU", new String[][]{{this.right}});
        this.nonTerminalInfo.put("QL", new String[][]{{this.right}});
        this.nonTerminalInfo.put("--", new String[][]{{this.right, "PP"}});
        this.nonTerminalInfo.put("CD", new String[][]{{this.right, "CD"}});
        this.nonTerminalInfo.put("NN", new String[][]{{this.right, "NN"}});
        this.nonTerminalInfo.put("NR", new String[][]{{this.right, "NR"}});
    }

    protected Tree findMarkedHead(Tree[] kids) {
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            if (!(kids[i].label() instanceof NegraLabel) || ((NegraLabel)kids[i].label()).getEdge() == null || !((NegraLabel)kids[i].label()).getEdge().equals("HD")) continue;
            return kids[i];
        }
        return null;
    }
}

