/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFunctions;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.util.MutableInteger;
import java.util.ArrayList;
import java.util.List;

public class Trees {
    public static int leftEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(0);
        if (Trees.leftEdge(t, root, i)) {
            return i.intValue();
        }
        return -1;
    }

    static boolean leftEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() + j);
            return false;
        }
        Tree[] kids = t1.children();
        int n = kids.length;
        for (int j = 0; j < n; ++j) {
            if (!Trees.leftEdge(t, kids[j], i)) continue;
            return true;
        }
        return false;
    }

    public static int rightEdge(Tree t, Tree root) {
        MutableInteger i = new MutableInteger(root.yield().size());
        if (Trees.rightEdge(t, root, i)) {
            return i.intValue();
        }
        return root.yield().size() + 1;
    }

    static boolean rightEdge(Tree t, Tree t1, MutableInteger i) {
        if (t == t1) {
            return true;
        }
        if (t1.isLeaf()) {
            int j = t1.yield().size();
            i.set(i.intValue() - j);
            return false;
        }
        Tree[] kids = t1.children();
        for (int j = kids.length - 1; j >= 0; --j) {
            if (!Trees.rightEdge(t, kids[j], i)) continue;
            return true;
        }
        return false;
    }

    public static Tree lexicalize(Tree t, HeadFinder hf) {
        Function<Tree, Tree> a = TreeFunctions.getLabeledTreeToCategoryWordTagTreeFunction();
        Tree t1 = a.apply(t);
        t1.percolateHeads(hf);
        return t1;
    }

    public static List leaves(Tree t) {
        ArrayList l = new ArrayList();
        Trees.leaves(t, l);
        return l;
    }

    private static void leaves(Tree t, List l) {
        if (t.isLeaf()) {
            l.add(t);
        } else {
            Tree[] kids = t.children();
            int n = kids.length;
            for (int j = 0; j < n; ++j) {
                Trees.leaves(kids[j], l);
            }
        }
    }

    public static boolean heads(Tree head, Tree node, HeadFinder hf) {
        if (node.isLeaf()) {
            return false;
        }
        return Trees.heads(head, hf.determineHead(node), hf);
    }

    public static Tree maximalProjection(Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        if (projection == root) {
            return root;
        }
        Tree parent = projection.parent(root);
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree applyToProjections(TreeVisitor v, Tree head, Tree root, HeadFinder hf) {
        Tree projection = head;
        Tree parent = projection.parent(root);
        if (parent == null && projection != root) {
            return null;
        }
        v.visitTree(projection);
        if (projection == root) {
            return root;
        }
        while (hf.determineHead(parent) == projection) {
            projection = parent;
            v.visitTree(projection);
            if (projection == root) {
                return root;
            }
            parent = projection.parent(root);
        }
        return projection;
    }

    public static Tree getTerminal(Tree tree, int n) {
        return Trees.getTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isLeaf()) {
                return tree;
            }
            return Trees.getTerminal(tree.children()[0], i, n);
        }
        if (tree.isLeaf()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        Tree[] kids = tree.children();
        for (int j = 0; j < kids.length; ++j) {
            Tree result = Trees.getTerminal(kids[j], i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Tree getPreTerminal(Tree tree, int n) {
        return Trees.getPreTerminal(tree, new MutableInteger(0), n);
    }

    static Tree getPreTerminal(Tree tree, MutableInteger i, int n) {
        if (i.intValue() == n) {
            if (tree.isPreTerminal()) {
                return tree;
            }
            return Trees.getPreTerminal(tree.children()[0], i, n);
        }
        if (tree.isPreTerminal()) {
            i.set(i.intValue() + tree.yield().size());
            return null;
        }
        Tree[] kids = tree.children();
        for (int j = 0; j < kids.length; ++j) {
            Tree result = Trees.getPreTerminal(kids[j], i, n);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List localTreeAsCatList(Tree t) {
        ArrayList<String> l = new ArrayList<String>(t.children().length + 1);
        l.add(t.label().value());
        for (int i = 0; i < t.children().length; ++i) {
            l.add(t.children()[i].label().value());
        }
        return l;
    }

    public static int objectEqualityIndexOf(Tree parent, Tree daughter) {
        for (int i = 0; i < parent.children().length; ++i) {
            if (daughter != parent.children()[i]) continue;
            return i;
        }
        return -1;
    }
}

