/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.NumberRangesFileFilter;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.FilePathProcessor;
import edu.stanford.nlp.util.FileProcessor;
import edu.stanford.nlp.util.Timing;
import java.io.File;
import java.io.FileFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiskTreebank
extends Treebank {
    private static final boolean PRINT_FILENAMES = false;
    private ArrayList<File> filePaths = new ArrayList();
    private ArrayList<FileFilter> fileFilters = new ArrayList();
    private File currentFile = null;
    private static final boolean BROKEN_NFS = true;

    public DiskTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public DiskTreebank(TreeReaderFactory trf) {
        super(trf);
    }

    public DiskTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
    }

    public DiskTreebank(int initialCapacity) {
        this(initialCapacity, new LabeledScoredTreeReaderFactory());
    }

    public DiskTreebank(int initialCapacity, TreeReaderFactory trf) {
        this(trf);
    }

    @Override
    public void clear() {
        this.filePaths.clear();
        this.fileFilters.clear();
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        this.filePaths.add(path);
        this.fileFilters.add(filt);
    }

    @Override
    public void apply(TreeVisitor tp) {
        for (Tree t : this) {
            tp.visitTree(t);
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public Iterator<Tree> iterator() {
        return new DiskTreebankIterator();
    }

    public static void main(String[] args) {
        int i = 0;
        int maxLength = -1;
        boolean normalized = false;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-maxLength") && i + 1 < args.length) {
                maxLength = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equals("-normalized")) {
                normalized = true;
                ++i;
                continue;
            }
            System.err.println("Unknown option: " + args[i]);
            ++i;
        }
        DiskTreebank treebank = normalized ? new DiskTreebank() : new DiskTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        if (i + 1 < args.length) {
            treebank.loadPath(args[i], (FileFilter)new NumberRangesFileFilter(args[i + 1], true));
        } else {
            treebank.loadPath(args[i]);
        }
        if (maxLength >= 0) {
            for (Tree t : treebank) {
                if (t.yield().length() > maxLength) continue;
                System.out.println(t);
            }
        } else {
            System.out.println();
            Timing.startTime();
            int num = 0;
            for (Tree t : treebank) {
                num += t.yield().length();
            }
            Timing.endTime("traversing corpus, counting words with iterator");
            System.err.println("There were " + num + " words in the treebank.");
            ((Treebank)treebank).apply(new TreeVisitor(){
                int num = 0;

                public void visitTree(Tree t) {
                    this.num += t.yield().length();
                }
            });
            System.out.println();
            Timing.endTime("traversing corpus, counting words with TreeVisitor");
            System.err.println("There were " + num + " words in the treebank.");
            System.out.println();
            Timing.startTime();
            System.out.println("This treebank contains " + treebank.size() + " trees.");
            Timing.endTime("size of corpus");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiskTreebankIterator
    implements Iterator<Tree> {
        private int fileUpto = -1;
        private int treeUpto;
        private List<String> files = new ArrayList<String>();
        private MemoryTreebank currentFileTrees;
        private boolean hasNext;

        private DiskTreebankIterator() {
            FileProcessor dtifp = new FileProcessor(){

                public void processFile(File file) {
                    DiskTreebankIterator.this.files.add(file.toString());
                }
            };
            int numPaths = DiskTreebank.this.filePaths.size();
            for (int i = 0; i < numPaths; ++i) {
                FilePathProcessor.processPath((File)DiskTreebank.this.filePaths.get(i), (FileFilter)DiskTreebank.this.fileFilters.get(i), dtifp);
            }
            this.currentFileTrees = new MemoryTreebank(DiskTreebank.this.treeReaderFactory(), DiskTreebank.this.encoding());
            this.hasNext = this.primeNextFile();
        }

        private boolean primeNextFile() {
            while (this.fileUpto < this.files.size()) {
                if (this.treeUpto < this.currentFileTrees.size()) {
                    return true;
                }
                this.currentFileTrees.clear();
                ++this.fileUpto;
                this.treeUpto = 0;
                if (this.fileUpto >= this.files.size()) continue;
                String fname = this.files.get(this.fileUpto);
                this.currentFileTrees.loadPath(fname);
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Tree next() {
            Tree ret = this.currentFileTrees.get(this.treeUpto++);
            this.hasNext = this.primeNextFile();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

