/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.BinaryFeature;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;

public class ExtractorMorpho
extends Extractor {
    int num;
    int t1;
    int t2 = -1;
    String tag1;
    String tag2;

    public boolean isPopulated(BinaryFeature f) {
        return f.indexedValues.length > GlobalHolder.thresholdRare;
    }

    public ExtractorMorpho(int num, int t1) {
        this.num = num;
        this.t1 = t1;
        this.tag1 = GlobalHolder.tags.getTag(t1);
    }

    public ExtractorMorpho(int num, int t1, int t2) {
        this.t1 = t1;
        this.t2 = t2;
        this.tag1 = GlobalHolder.tags.getTag(t1);
        this.tag2 = GlobalHolder.tags.getTag(t2);
    }

    String extract(History h) {
        String word = TestSentence.toNice(GlobalHolder.pairs.get(h, 0, false));
        if (this.t2 == -1) {
            if (word.length() < this.num) {
                return "0";
            }
            String wpref = TestSentence.toSt(word.substring(0, word.length() - this.num));
            if (GlobalHolder.dict.getCount(wpref, this.tag1) > 0) {
                return String.valueOf(word.substring(word.length() - this.num, word.length())) + this.tag1;
            }
            return "0";
        }
        int dashIndex = word.indexOf("-");
        if (dashIndex > -1) {
            String wordpref = TestSentence.toSt(word.substring(0, dashIndex));
            String wordsuff = TestSentence.toSt(word.substring(dashIndex + 1));
            if (GlobalHolder.dict.getCount(wordpref, this.tag1) > 0 && GlobalHolder.dict.getCount(wordsuff, this.tag2) > 0) {
                return String.valueOf(this.tag1) + "&" + this.tag2;
            }
        }
        return "0";
    }
}

