/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class PTB2TextLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final String ZZ_CMAP_PACKED = "\n\u0000\u0001\u0006\u0015\u0000\u0001\u0001\u0001\u0005\u0002\u0000\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0001\u000f\u0001\u0010\u0002\u0000\u0001\u0005\u0001\u000b\u0001\u0004\u000b\u0000\u0001\u0005\u0001\u0005\u0003\u0000\u0001\u0005\u0002\u0000\u0001\u000e\u0001\u0011\b\u0000\u0001\f\u0001\u0000\u0001\t\u0003\u0000\u0001\r\u0001\u0000\u0001\n\u0006\u0000\u0001\u0012\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0003\r\u0000\u0001\u0007\u0005\u0000\u0001\b\uff8b\u0000";
    private static final char[] ZZ_CMAP = PTB2TextLexer.zzUnpackCMap("\n\u0000\u0001\u0006\u0015\u0000\u0001\u0001\u0001\u0005\u0002\u0000\u0001\u0015\u0001\u0014\u0001\u0000\u0001\u0002\u0001\u000f\u0001\u0010\u0002\u0000\u0001\u0005\u0001\u000b\u0001\u0004\u000b\u0000\u0001\u0005\u0001\u0005\u0003\u0000\u0001\u0005\u0002\u0000\u0001\u000e\u0001\u0011\b\u0000\u0001\f\u0001\u0000\u0001\t\u0003\u0000\u0001\r\u0001\u0000\u0001\n\u0006\u0000\u0001\u0012\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0003\r\u0000\u0001\u0007\u0005\u0000\u0001\b\uff8b\u0000");
    private static final int[] ZZ_ACTION = PTB2TextLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\b\u0001\u0001\u0000\u0002\u0002\u0003\u0000\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0002\u0001\u0001\u0007\u0001\b\u0001\t\u0001\n\u0004\u0000\u0002\u0001\u0001\u000b\u0001\f\u0002\u0000\u0002\u0001\u0002\u0000";
    private static final int[] ZZ_ROWMAP = PTB2TextLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0016\u0000,\u0000B\u0000X\u0000n\u0000\u0084\u0000\u009a\u0000\u00b0\u0000\u00c6\u0000\u00dc\u0000X\u0000\u00f2\u0000\u0108\u0000\u011e\u0000X\u0000X\u0000X\u0000X\u0000\u0134\u0000\u014a\u0000X\u0000X\u0000X\u0000X\u0000\u0160\u0000\u0176\u0000\u018c\u0000\u01a2\u0000\u01b8\u0000\u01ce\u0000X\u0000X\u0000\u01e4\u0000\u01fa\u0000\u0210\u0000\u0226\u0000\u023c\u0000\u0252";
    private static final int[] ZZ_TRANS = PTB2TextLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0002\u0001\u0004\u0002\u0002\u0001\u0005\u0004\u0002\u0001\u0006\u0003\u0002\u0001\u0007\u0002\u0002\u0001\b\u0002\u0002\u0001\t\u0001\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u000f\u0002\u0002\u0000\u0001\n\u0001\u0000\u0001\u000b\u0001\f\u0001\u0000\u0001\r\u0001\u0000\u0001\u000e\u0001\u0000\u0001\u000f\u0004\u0000\u0001\u0010\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0000\u0001\u0002\u0001\u0013\u0001\u0002\u0001\u0014\u0002\u0002\u0001\u0000\u000f\u0002\u0016\u0000\u0001\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0005\u0002\u0001\u0015\n\u0002\u0001\u0016\u0004\u0002\u0001\u0000\u0010\u0002\u0001\u0017\u0004\u0002\u0001\u0000\u0010\u0002\u0001\u0018\u0004\u0002\u0001\u0000\u000f\u0002\u0001\f\u0001\u0000\u0001\u0019\u0003\f\u0001\u0000\u000f\f\u0004\u0000\u0001\u001a\u0013\u0000\u0001\u001b\u0015\u0000\u0001\u001c \u0000\u0001\u001d\b\u0000\u0001\u0002\u0001\u0019\u0004\u0002\u0001\u0000\u0010\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0006\u0002\u0001\u001e\u0003\u0002\u0001\u001f\u0004\u0002\u0004\u0000\u0001\f\u0019\u0000\u0001 \u0017\u0000\u0001!\u0018\u0000\u0001\"\u0003\u0000\u0001#\u0004\u0000\u0001\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0007\u0002\u0001$\b\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0007\u0002\u0001%\u0007\u0002\u000e\u0000\u0001&\u0015\u0000\u0001'\u0007\u0000\u0001\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0004\u0002\u0001\u0007\u000b\u0002\u0001\u0000\u0004\u0002\u0001\u0000\u0004\u0002\u0001\b\n\u0002\u000b\u0000\u0001\u0010\u0015\u0000\u0001\u0011\n\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = PTB2TextLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0003\u0001\u0001\t\u0004\u0001\u0001\u0000\u0001\u0001\u0001\t\u0003\u0000\u0004\t\u0002\u0001\u0004\t\u0004\u0000\u0002\u0001\u0002\t\u0002\u0000\u0002\u0001\u0002\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzPushbackPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;

    private static int[] zzUnpackAction() {
        int[] result = new int[39];
        int offset = 0;
        offset = PTB2TextLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[39];
        int offset = 0;
        offset = PTB2TextLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[616];
        int offset = 0;
        offset = PTB2TextLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[39];
        int offset = 0;
        offset = PTB2TextLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    PTB2TextLexer(Reader in) {
        this.zzReader = in;
    }

    PTB2TextLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 86) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzPushbackPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) < 0) {
            return true;
        }
        this.zzEndRead += numRead;
        return false;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzPushbackPos = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public String next() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block26: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = this.zzLexicalState;
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 5: {
                    return "%";
                }
                case 13: {
                    continue block26;
                }
                case 1: {
                    return this.yytext();
                }
                case 14: {
                    continue block26;
                }
                case 2: {
                    return this.yytext().substring(1, this.yytext().length());
                }
                case 15: {
                    continue block26;
                }
                case 7: {
                    return "(";
                }
                case 16: {
                    continue block26;
                }
                case 9: {
                    return "$";
                }
                case 17: {
                    continue block26;
                }
                case 11: {
                    return "n't";
                }
                case 18: {
                    continue block26;
                }
                case 4: {
                    return "]";
                }
                case 19: {
                    continue block26;
                }
                case 6: {
                    return "`";
                }
                case 20: {
                    continue block26;
                }
                case 12: {
                    return "N'T";
                }
                case 21: {
                    continue block26;
                }
                case 8: {
                    return "[";
                }
                case 22: {
                    continue block26;
                }
                case 10: {
                    return "\"";
                }
                case 23: {
                    continue block26;
                }
                case 3: {
                    return ")";
                }
                case 24: {
                    continue block26;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java PTB2TextLexer <inputfile>");
        } else {
            for (int i = 0; i < argv.length; ++i) {
                PTB2TextLexer scanner = null;
                try {
                    scanner = new PTB2TextLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.next();
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
            }
        }
    }
}

