/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZHeadFinder;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZLanguagePack;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZPennTreeNormalizer;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class TueBaDZParserParams
extends AbstractTreebankParserParams {
    private static final long serialVersionUID = 7303189408025355170L;

    public TueBaDZParserParams() {
        super(new TueBaDZLanguagePack());
        this.setInputEncoding(this.tlp.getEncoding());
        this.setOutputEncoding(this.tlp.getEncoding());
    }

    public List defaultTestSentence() {
        return Arrays.asList("Veruntreute", "die", "AWO", "Spendengeld", "?");
    }

    public String[] sisterSplitters() {
        return new String[0];
    }

    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp);
    }

    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.tlp);
    }

    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory());
    }

    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory());
    }

    public TreeReaderFactory treeReaderFactory() {
        return new TueBaDZTreeReaderFactory();
    }

    public int setOptionFlag(String[] args, int i) {
        return i;
    }

    public void display() {
        System.out.println("TueBaDZParserParams (no options).");
    }

    public HeadFinder headFinder() {
        return new TueBaDZHeadFinder();
    }

    public Tree transformTree(Tree t, Tree root) {
        return t;
    }

    private static class TueBaDZTreeReaderFactory
    implements TreeReaderFactory,
    Serializable {
        private static final long serialVersionUID = 1614799885744961795L;

        private TueBaDZTreeReaderFactory() {
        }

        public TreeReader newTreeReader(Reader in) {
            TueBaDZPennTreeNormalizer tn = new TueBaDZPennTreeNormalizer();
            return new PennTreeReader(in, new LabeledScoredTreeFactory(new StringLabelFactory()), tn);
        }
    }
}

