/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.IConsoleListener;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class NotificationListener
implements ISVNNotifyListener {
    private static NotificationListener instance;

    private NotificationListener() {
    }

    private IConsoleListener getConsoleListener() {
        return SVNProviderPlugin.getPlugin().getConsoleListener();
    }

    public static NotificationListener getInstance() {
        if (instance == null) {
            instance = new NotificationListener();
        }
        return instance;
    }

    public void logCommandLine(String commandLine) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.logCommandLine(commandLine);
        }
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.logCompleted(message);
        }
    }

    public void logError(String message) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.logError(message);
        }
    }

    public void logMessage(String message) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.logMessage(message);
        }
    }

    public void onNotify(File path, SVNNodeKind kind) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.onNotify(path, kind);
        }
    }

    public void setCommand(int command) {
        IConsoleListener consoleListener = this.getConsoleListener();
        if (consoleListener != null) {
            consoleListener.setCommand(command);
        }
    }
}

