/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timex3;

import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;

public interface ITimex3
extends IStructuredData {
    public static final IHasPosition noPosition = new SimplePosition(0, 0);

    public ISegmentSet getExpression();

    public Type getType();

    public ISegmentSet getQuantifier();

    public ISegmentSet getFrequency();

    public Function getFunction();

    public boolean isTemporalFunction();

    public String getValue();

    public Mod getModifier();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Function implements IHasName,
    IHasDescription
    {
        NONE("None", "No special function in relation to the document."),
        CREATION_TIME("Creation Time", "The time the story was created."),
        EXPIRATION_TIME("Expiration Time", "The time the story expires (if any)."),
        MODIFICATION_TIME("Modification Time", "The time the story was modified."),
        PUBLICATION_TIME("Publication Time", "The time the story was published."),
        RELEASE_TIME("Release Time", "The time the story may be released (if not immediately)."),
        RECEPTION_TIME("Reception Time", "The time the story was received by a customer."),
        UNKNOWN("Unknown", "Has an unknown function in relation to the document."),
        UNSPECIFIED("Unspecified", "The function of the expression in the document has not yet been specified.");

        private final String name;
        private final String desc;

        private Function(String name, String desc) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (desc.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mod implements IHasName,
    IHasDescription
    {
        NONE("None", "No modifier"),
        BEFORE("Before", "A point in time"),
        AFTER("After", "A point in time"),
        ON_OR_BEFORE("On or before", "A point in time"),
        ON_OR_AFTER("On or after", "A point in time"),
        LESS_THAN("Less than", "A duration"),
        MORE_THAN("More than", "A duration"),
        EQUAL_OR_LESS("Equal or less", "A duration"),
        EQUAL_OR_MORE("Equal or more", "A duration"),
        START("Start", "A point in time or duration"),
        MID("Middle", "A point in time or duration"),
        END("End", "A point in time or duration"),
        APPROX("Approximately", "A point in time or duration"),
        UNKNOWN("Unknown", "Has a modifier of unknown type"),
        UNSPECIFIED("Unspecified", "The modifier has yet to be specified");

        private final String name;
        private final String desc;

        private Mod(String name, String desc) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (desc.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements IHasName,
    IHasDescription
    {
        DATE("Date", "The expression describes a calendar time, e.g., 'Friday, October 1, 1999', 'yesterday', or 'this year's summer.'"),
        TIME("Time", "The expression refers to a time of the day, even if indefinite, e.g., 'ten minutes to 3', 'the morning of Jan 31', or 'last night.'"),
        DURATION("Duration", "The expression describes an explicite duration, e.g., '2 months', 'three weeks', or '20 days.'"),
        SET("Set", "The expression describes a set of times, e.g., 'twice a week', or 'every 2 days.'"),
        UNKNOWN("Unknown", "An unknown temporal expression type"),
        UNSPECIFIED("Unspecified", "The type of the temporal expression has not yet been specified");

        private final String name;
        private final String desc;

        private Type(String name, String desc) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (desc.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

