/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.rules;

import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.problems.GenericRoleSetProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoGenericRoleSetsRule
extends AbstractBuildRule {
    public NoGenericRoleSetsRule() {
        super(SemRoleRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> generics = new HashSet<IDesc>();
        for (IDesc semrole : model.getData().getDescriptions(SemRoleRep.getInstance())) {
            ISemRole data = (ISemRole)semrole.getData();
            if (!data.getRoleset().getID().equals("lemma.XX") || CheckMetaRep.isChecked((IDesc)semrole, (String)"edu.mit.semantics.core.problem.genericRoleSet")) continue;
            generics.add(semrole);
        }
        if (generics.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc semrole : generics) {
            result.add((Object)new GenericRoleSetProblem(semrole, this.getID()));
        }
        return result;
    }
}

