/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.ISynset;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.context.ContextArg;
import edu.mit.semantics.core.rep.context.ContextArgMapper;
import edu.mit.semantics.core.rep.context.ContextRelation;
import edu.mit.semantics.core.rep.context.ContextRole;
import edu.mit.semantics.core.rep.context.GeneratePropCtxRelChange;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRelation;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.DescriptionMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import edu.mit.wordnet.core.WordnetMessages;
import edu.mit.wordnet.core.WordnetPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Version;

public class ContextRelationRep
extends AbstractRep {
    public static final String ID = "edu.mit.semantics.rep.contextrelation";
    private static IRep instance;

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public ContextRelationRep() {
        super(IContextRelation.class, v03, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)RefExpRep.getInstance());
        container.add((Object)EventRep.getInstance());
    }

    public String serialize(IData data) {
        return this.serializeVer03(data);
    }

    public ContextRelation reconstitute(IHasPosition p, String data, IStoryModel model, Version ver) {
        if (v01.equals((Object)ver)) {
            return this.reconstituteVer01(p, data, model);
        }
        if (v02.equals((Object)ver)) {
            return this.reconstituteVer02(p, data, model);
        }
        if (v03.equals((Object)ver)) {
            return this.reconstituteVer03(p, data, model);
        }
        return this.reconstitute(p, data, model);
    }

    public ContextRelation reconstitute(IHasPosition p, String data, IStoryModel model) {
        return this.reconstitute(p, data, model, this.getVersion());
    }

    protected ContextRelation reconstituteVer01(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(data);
        SegmentSet signal = null;
        if (((String)fields.get(1)).length() > 0) {
            SegmentMapper segMapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
            List segList = segMapper.reconstitute((String)fields.get(1));
            signal = new SegmentSet((Collection)segList);
        }
        DescriptionMapper descMapper = new DescriptionMapper(model.getData());
        List argFillers = descMapper.reconstitute((String)fields.get(2));
        ArrayList<ContextArg> args = new ArrayList<ContextArg>(argFillers.size());
        for (IDesc filler : argFillers) {
            args.add(new ContextArg(0, IContextRole.UNKNOWN, filler, 0));
        }
        return new ContextRelation((Collection<? extends ISegment>)signal, args);
    }

    protected ContextRelation reconstituteVer02(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.COLON.reconstitute(data);
        SegmentSet signal = null;
        if (((String)fields.get(0)).length() > 0) {
            SegmentMapper segMapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
            List segList = segMapper.reconstitute((String)fields.get(0));
            signal = new SegmentSet((Collection)segList);
        }
        LinkedList<ContextArg> args = new LinkedList<ContextArg>();
        IDictionary dict = ContextRelationRep.getDictionary(model.getData());
        List argStrs = BlockMapper.PIPE.reconstitute((String)fields.get(1));
        for (String argStr : argStrs) {
            IContextRole role;
            List argParts = BlockMapper.COMMA.reconstitute(argStr);
            String firstArgPart = (String)argParts.get(0);
            if ("UNKNOWN_ROLE".equals(firstArgPart)) {
                role = IContextRole.UNKNOWN;
            } else if ("NO_ROLE".equals(firstArgPart)) {
                role = IContextRole.NONE;
            } else {
                ISynset synset = ContextArgMapper.getSynsetForID((String)argParts.get(0), dict);
                role = new ContextRole(synset);
            }
            IDesc filler = model.getData().getDescription(Long.parseLong((String)argParts.get(1)));
            args.add(new ContextArg(0, role, filler, 0));
        }
        return new ContextRelation((Collection<? extends ISegment>)signal, args);
    }

    protected ContextRelation reconstituteVer03(IHasPosition p, String data, IStoryModel model) {
        List fields = BlockMapper.PIPE.reconstitute(data);
        SegmentSet signal = null;
        String sigStr = (String)fields.get(0);
        if (sigStr.length() > 0) {
            SegmentMapper segMapper = new SegmentMapper(TokenRep.getInstance(), model.getData());
            List segList = segMapper.reconstitute(sigStr);
            signal = new SegmentSet((Collection)segList);
        }
        IDictionary dict = ContextRelationRep.getDictionary(model.getData());
        ContextArgMapper argMapper = new ContextArgMapper(dict, model.getData());
        ArrayList<IContextArg> args = new ArrayList<IContextArg>(fields.size() - 2);
        int i = 1;
        while (i < fields.size()) {
            args.add(argMapper.reconstituteArg((String)fields.get(i)));
            ++i;
        }
        return new ContextRelation((Collection<? extends ISegment>)signal, args);
    }

    protected String serializeVer03(IData data) {
        IContextRelation cr = (IContextRelation)data;
        ArrayList<String> fields = new ArrayList<String>(cr.getArguments().size() + 2);
        fields.add(SegmentMapper.serializeStatic((Collection)cr.getSignal()));
        for (IContextArg iContextArg : cr.getArguments()) {
            fields.add(ContextArgMapper.serializeArgStatic(iContextArg));
        }
        return BlockMapper.PIPE.serialize(fields);
    }

    public static String getDictionaryID(IStoryData data) {
        IConfiguration config = data.getConfiguration(ContextRelationRep.getInstance());
        return (String)config.get((Object)"wordnet");
    }

    public static IDictionary getDictionary(IStoryData data) {
        String wordnetID = ContextRelationRep.getDictionaryID(data);
        if (wordnetID == null) {
            return null;
        }
        return (IDictionary)WordnetPlugin.getDefault().getDictionaryManager().create(wordnetID);
    }

    protected IConfigDescriptor createConfigurationDescriptor(String id, String name, String desc) {
        return new ContextRelRepConfigDescriptor(id, name, desc);
    }

    public IModelChange getBatchModelChange() {
        return new GeneratePropCtxRelChange();
    }

    public static class ContextRelRepConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public ContextRelRepConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public ContextRelRepConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("wordnet", WordnetMessages.PARAM_Wordnet_name, WordnetMessages.PARAM_Wordnet_desc, (IValidator)new ManagerBackedListValidator((IManager)WordnetPlugin.getDefault().getDictionaryManager()), false, "DefaultWordnetID", WordnetPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

