/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.DefaultFeatureParser;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.InstallHandlerEntryModel;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.xml.sax.SAXException;

public class FeatureModelFactory {
    public FeatureModel parseFeature(InputStream stream) throws CoreException, SAXException {
        return this.parseFeature(stream, null);
    }

    public FeatureModel parseFeature(InputStream stream, String location) throws CoreException, SAXException {
        DefaultFeatureParser parser = new DefaultFeatureParser();
        parser.init(this, location);
        FeatureModel featureModel = null;
        try {
            featureModel = parser.parse(stream);
            if (parser.getStatus() != null) {
                MultiStatus status = parser.getStatus();
                throw new CoreException((IStatus)status);
            }
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Messages.FeatureModelFactory_ErrorAccesingFeatureStream, e);
        }
        return featureModel;
    }

    public FeatureModel createFeatureModel() {
        return new FeatureModel();
    }

    public IncludedFeatureReferenceModel createIncludedFeatureReferenceModel() {
        return new IncludedFeatureReferenceModel();
    }

    public InstallHandlerEntryModel createInstallHandlerEntryModel() {
        return new InstallHandlerEntryModel();
    }

    public ImportModel createImportModel() {
        return new ImportModel();
    }

    public PluginEntryModel createPluginEntryModel() {
        return new PluginEntryModel();
    }

    public NonPluginEntryModel createNonPluginEntryModel() {
        return new NonPluginEntryModel();
    }

    public URLEntryModel createURLEntryModel() {
        return new URLEntryModel();
    }
}

