/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.URLTransfer;

public abstract class URLDropAdapter
extends DropTargetAdapter {
    private boolean convertFileToURL = false;

    protected URLDropAdapter(boolean convertFileToURL) {
        this.convertFileToURL = convertFileToURL;
    }

    public void dragEnter(DropTargetEvent e) {
        if (!this.dropTargetIsValid(e)) {
            e.detail = 0;
            return;
        }
        if (e.detail == 0) {
            e.detail = 4;
        }
    }

    public void dragOperationChanged(DropTargetEvent e) {
        if (e.detail == 0) {
            e.detail = 4;
        }
    }

    public void drop(DropTargetEvent event) {
        String urlText;
        if (this.dropTargetIsValid(event) && (urlText = this.getURLText(event)) != null) {
            this.handleDrop(urlText, event);
            return;
        }
        event.detail = 0;
    }

    private String getURLText(DropTargetEvent event) {
        String[] names;
        if (URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
            return (String)URLTransfer.getInstance().nativeToJava(event.currentDataType);
        }
        if (this.convertFileToURL && FileTransfer.getInstance().isSupportedType(event.currentDataType) && (names = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType)) != null && names.length == 1) {
            return URLValidator.makeJarURLString(names[0]);
        }
        return null;
    }

    protected boolean dropTargetIsValid(DropTargetEvent event) {
        if (URLTransfer.getInstance().isSupportedType(event.currentDataType) && URLTransfer.getInstance().nativeToJava(event.currentDataType) != null) {
            return true;
        }
        if (!this.convertFileToURL) {
            return false;
        }
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            String[] names = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
            return names != null && names.length == 1;
        }
        return false;
    }

    protected abstract void handleDrop(String var1, DropTargetEvent var2);
}

