/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.stem;

import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.morph.WordnetStemmer;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.story.core.algorithm.AbstractAlgorithm;
import edu.mit.story.core.manager.IManager;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.validation.IValidator;
import edu.mit.story.core.validation.ManagerBackedListValidator;
import edu.mit.story.core.validation.PreferenceStoreBackedPropertyDescriptor;
import edu.mit.wordnet.core.WordnetMessages;
import edu.mit.wordnet.core.WordnetPlugin;
import edu.mit.wordnet.core.WordnetUtils;
import edu.mit.wordnet.core.rep.sense.dict.IDictionaryManager;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordnetBackedStemmer
extends AbstractAlgorithm
implements IStemmer {
    WordnetStemmer fStemmer;

    protected boolean doInit() {
        String wordnetID = (String)this.getConfiguration().get((Object)"wordnet");
        if (wordnetID == null) {
            return false;
        }
        IDictionaryManager manager = WordnetPlugin.getDefault().getDictionaryManager();
        IExtendedDictionary dict = manager.getDictionary(wordnetID);
        if (dict == null) {
            return false;
        }
        this.fStemmer = new WordnetStemmer((IDictionary)dict);
        return true;
    }

    public SortedSet<String> getStems(String word, ITag tag) {
        POS pos = WordnetUtils.convertToPOS(tag);
        List stems = this.fStemmer.findStems(word, pos);
        if (stems == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>(stems);
        result.remove(word);
        return result;
    }

    protected IConfigDescriptor createConfigurationDescriptor() {
        return new WordnetStemmerConfigDescriptor();
    }

    public static class WordnetStemmerConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public WordnetStemmerConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public WordnetStemmerConfigDescriptor() {
            PreferenceStoreBackedPropertyDescriptor d = new PreferenceStoreBackedPropertyDescriptor("wordnet", WordnetMessages.PARAM_Wordnet_name, WordnetMessages.PARAM_Wordnet_desc, (IValidator)new ManagerBackedListValidator((IManager)WordnetPlugin.getDefault().getDictionaryManager()), false, "DefaultWordnetID", WordnetPlugin.getDefault().getPreferenceStore());
            this.put(d.getID(), d);
        }
    }
}

