/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.problems;

import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.wordnet.core.rep.sense.ISense;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedAuxiliaryProblem
extends StoryProblem {
    public static final String ID = "edu.mit.wordnet.core.problem.taggedAuxiliary";

    public TaggedAuxiliaryProblem(IDesc desc, String buildRuleID) {
        this(Collections.singleton(desc), buildRuleID);
    }

    public TaggedAuxiliaryProblem(Collection<? extends IDesc> descs, String buildRuleID) {
        super(SenseRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Sense Tagged Auxiliary");
        this.setDescs(descs);
        this.setSeverity(2);
        IDescSet ds = this.getDescs().getDescriptions(SenseRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (ds.size() > 1) {
            this.setDescription("There are " + ds.size() + " auxiliaries with senses assigned (only first shown)");
            this.setPosition((IHasPosition)ds.first());
        } else {
            IDesc d = (IDesc)ds.first();
            ISense sense = (ISense)d.getData();
            IBaseToken token = (IBaseToken)sense.getWord().getData();
            this.setPosition((IHasPosition)d);
            this.setDescription("The auxiliary '" + token.getSurface() + "' has a sense assignment");
        }
    }
}

