/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int gvColumns;
    int parentingHandle;
    int headerTemplate;
    int columnCount;
    int itemCount;
    TreeItem anchor;
    TreeItem lastSelection;
    TreeItem unselect;
    TreeItem reselect;
    TreeColumn[] columns;
    byte headerVisibility = (byte)2;
    boolean ignoreSelection;
    boolean shiftDown;
    boolean ctrlDown;
    static final String HEADER_PART_NAME = "SWT_PART_HEADER";
    static final String SCROLLVIEWER_PART_NAME = "SWT_PART_SCROLLVIEWER";
    static final String CHECKBOX_PART_NAME = "SWT_PART_CHECKBOX";
    static final String IMAGE_PART_NAME = "SWT_PART_IMAGE";
    static final String TEXT_PART_NAME = "SWT_PART_TEXT";
    static final String CONTENTPANEL_PART_NAME = "SWT_PART_CONTENTPANEL";
    static final String RENDER_PANEL_NAME = "SWT_PART_RENDERPANEL";
    static String scrollViewerStyle = "<Style TargetType=\"ScrollViewer\" xmlns=\"http://schemas.microsoft.com/winfx/2006/xaml/presentation\" xmlns:s=\"clr-namespace:System;assembly=mscorlib\" xmlns:x=\"http://schemas.microsoft.com/winfx/2006/xaml\"><Setter Property=\"UIElement.Focusable\" Value=\"False\"/><Setter Property=\"Control.Template\"><Setter.Value><ControlTemplate TargetType=\"ScrollViewer\"><Grid Background=\"{TemplateBinding Control.Background}\" SnapsToDevicePixels=\"True\"><Grid.ColumnDefinitions><ColumnDefinition Width=\"*\" /><ColumnDefinition Width=\"Auto\" /></Grid.ColumnDefinitions><Grid.RowDefinitions><RowDefinition Height=\"*\" /><RowDefinition Height=\"Auto\" /></Grid.RowDefinitions><DockPanel Margin=\"{TemplateBinding Control.Padding}\"><ScrollViewer HorizontalScrollBarVisibility=\"Hidden\" VerticalScrollBarVisibility=\"Hidden\" Focusable=\"False\" DockPanel.Dock=\"Top\"><GridViewHeaderRowPresenter Name=\"SWT_PART_HEADER\" Margin=\"2,0,2,0\" Visibility=\"Collapsed\" ColumnHeaderToolTip=\"{x:Null}\" ColumnHeaderContainerStyle=\"{x:Null}\" SnapsToDevicePixels=\"{TemplateBinding UIElement.SnapsToDevicePixels}\" AllowsColumnReorder=\"True\" ColumnHeaderTemplate=\"{x:Null}\" ColumnHeaderContextMenu=\"{x:Null}\"><GridViewHeaderRowPresenter.Columns><TemplateBinding Property=\"GridViewHeaderRowPresenter.Columns\"/></GridViewHeaderRowPresenter.Columns></GridViewHeaderRowPresenter></ScrollViewer><ScrollContentPresenter VirtualizingStackPanel.IsVirtualizing=\"True\" CanVerticallyScroll=\"False\" CanHorizontallyScroll=\"False\" Name=\"PART_ScrollContentPresenter\" SnapsToDevicePixels=\"{TemplateBinding UIElement.SnapsToDevicePixels}\" ContentTemplate=\"{TemplateBinding ContentControl.ContentTemplate}\" CanContentScroll=\"{TemplateBinding ScrollViewer.CanContentScroll}\" Content=\"{TemplateBinding ContentControl.Content}\" KeyboardNavigation.DirectionalNavigation=\"Local\" /></DockPanel><ScrollBar Value=\"{TemplateBinding HorizontalOffset}\" Maximum=\"{TemplateBinding ScrollViewer.ScrollableWidth}\" Visibility=\"{TemplateBinding ScrollViewer.ComputedHorizontalScrollBarVisibility}\" Name=\"PART_HorizontalScrollBar\" Cursor=\"Arrow\"  Minimum=\"0\"  Orientation=\"Horizontal\"  Grid.Row=\"1\" ViewportSize=\"{TemplateBinding ViewportWidth}\"/><ScrollBar Value=\"{TemplateBinding VerticalOffset}\" Maximum=\"{TemplateBinding ScrollViewer.ScrollableHeight}\" Visibility=\"{TemplateBinding ScrollViewer.ComputedVerticalScrollBarVisibility}\"  Name=\"PART_VerticalScrollBar\" Cursor=\"Arrow\" Minimum=\"0\" Orientation=\"Vertical\" Grid.Column=\"1\" ViewportSize=\"{TemplateBinding ViewportHeight}\" /><DockPanel Background=\"{x:Null}\" LastChildFill=\"False\" Grid.Column=\"1\" Grid.Row=\"1\"><Rectangle Width=\"1\" Visibility=\"{TemplateBinding ScrollViewer.ComputedVerticalScrollBarVisibility}\" Fill=\"#FFFFFFFF\" DockPanel.Dock=\"Left\" /><Rectangle Height=\"1\" Visibility=\"{TemplateBinding ScrollViewer.ComputedHorizontalScrollBarVisibility}\" Fill=\"#FFFFFFFF\" DockPanel.Dock=\"Top\" /></DockPanel></Grid></ControlTemplate></Setter.Value></Setter></Style>";

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int backgroundHandle() {
        return this.parentingHandle;
    }

    boolean checkData(TreeItem item) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            int parentItem = OS.FrameworkElement_Parent(item.handle);
            int items = OS.ItemsControl_Items(parentItem);
            int index = OS.ItemCollection_IndexOf(items, item.handle);
            OS.GCHandle_Free(items);
            OS.GCHandle_Free(parentItem);
            Event event = new Event();
            event.item = item;
            event.index = index;
            this.sendEvent(36, event);
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        this.clear(this.handle, index, all);
    }

    void clear(int parentHandle, int index, boolean all) {
        int items = OS.ItemsControl_Items(parentHandle);
        TreeItem item = this.getItem(items, index, false);
        if (item != null) {
            item.clear();
            if (all) {
                this.clearAll(item, true);
            }
        }
        OS.GCHandle_Free(items);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(null, all);
    }

    void clearAll(TreeItem parentItem, boolean all) {
        int count = parentItem != null ? parentItem.itemCount : this.itemCount;
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        int i = 0;
        while (i < count) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null) {
                item.clear();
                if (all) {
                    this.clearAll(item, true);
                }
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    int createCellTemplate(int index) {
        int verticalAlignmentProperty;
        int template = OS.gcnew_DataTemplate();
        int renderPanelType = OS.SWTDockPanel_typeid();
        int renderPanelName = this.createDotNetString(RENDER_PANEL_NAME, false);
        int onRenderNode = OS.gcnew_FrameworkElementFactory(renderPanelType, renderPanelName);
        OS.GCHandle_Free(renderPanelName);
        OS.GCHandle_Free(renderPanelType);
        int jniRefProperty = OS.SWTDockPanel_JNIRefProperty();
        OS.FrameworkElementFactory_SetValueInt(onRenderNode, jniRefProperty, this.jniRef);
        OS.GCHandle_Free(jniRefProperty);
        int contentPanelName = this.createDotNetString(CONTENTPANEL_PART_NAME, false);
        int contentPanelType = OS.StackPanel_typeid();
        int cellContentNode = OS.gcnew_FrameworkElementFactory(contentPanelType, contentPanelName);
        OS.GCHandle_Free(contentPanelType);
        OS.GCHandle_Free(contentPanelName);
        int clipProperty = OS.UIElement_ClipToBoundsProperty();
        OS.FrameworkElementFactory_SetValue(cellContentNode, clipProperty, true);
        OS.GCHandle_Free(clipProperty);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(cellContentNode, orientationProperty, 0);
        OS.GCHandle_Free(orientationProperty);
        if (index == 0 && (this.style & 0x20) != 0) {
            int checkBoxType = OS.CheckBox_typeid();
            int checkBoxName = this.createDotNetString(CHECKBOX_PART_NAME, false);
            int checkBoxNode = OS.gcnew_FrameworkElementFactory(checkBoxType, checkBoxName);
            verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
            OS.FrameworkElementFactory_SetValueVerticalAlignment(checkBoxNode, verticalAlignmentProperty, 1);
            int marginProperty = OS.FrameworkElement_MarginProperty();
            int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
            OS.FrameworkElementFactory_SetValue(checkBoxNode, marginProperty, thickness);
            OS.FrameworkElementFactory_AppendChild(cellContentNode, checkBoxNode);
            OS.GCHandle_Free(thickness);
            OS.GCHandle_Free(marginProperty);
            OS.GCHandle_Free(verticalAlignmentProperty);
            OS.GCHandle_Free(checkBoxName);
            OS.GCHandle_Free(checkBoxNode);
            OS.GCHandle_Free(checkBoxType);
        }
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(textType);
        verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
        OS.FrameworkElementFactory_SetValueVerticalAlignment(textNode, verticalAlignmentProperty, 1);
        OS.GCHandle_Free(verticalAlignmentProperty);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(imageType);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        OS.GCHandle_Free(marginProperty);
        OS.GCHandle_Free(thickness);
        int stretchProperty = OS.Image_StretchProperty();
        OS.FrameworkElementFactory_SetValueStretch(imageNode, stretchProperty, 0);
        OS.GCHandle_Free(stretchProperty);
        OS.FrameworkElementFactory_AppendChild(cellContentNode, imageNode);
        OS.GCHandle_Free(imageNode);
        OS.FrameworkElementFactory_AppendChild(cellContentNode, textNode);
        OS.GCHandle_Free(textNode);
        OS.FrameworkElementFactory_AppendChild(onRenderNode, cellContentNode);
        OS.GCHandle_Free(cellContentNode);
        OS.FrameworkTemplate_VisualTree(template, onRenderNode);
        OS.GCHandle_Free(onRenderNode);
        return template;
    }

    int createControlTemplate() {
        int template = OS.gcnew_ControlTemplate();
        int borderType = OS.Border_typeid();
        int borderNode = OS.gcnew_FrameworkElementFactory(borderType);
        int brushProperty = OS.Control_BorderBrushProperty();
        int brushBinding = OS.gcnew_TemplateBindingExtension(brushProperty);
        OS.FrameworkElementFactory_SetValue(borderNode, brushProperty, brushBinding);
        int thicknessProperty = OS.Control_BorderThicknessProperty();
        int thicknessBinding = OS.gcnew_TemplateBindingExtension(thicknessProperty);
        OS.FrameworkElementFactory_SetValue(borderNode, thicknessProperty, thicknessBinding);
        int scrollViewerType = OS.ScrollViewer_typeid();
        int scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false);
        int scrollViewerNode = OS.gcnew_FrameworkElementFactory(scrollViewerType, scrollViewerName);
        int itemsPresenterType = OS.ItemsPresenter_typeid();
        int itemsPresenterNode = OS.gcnew_FrameworkElementFactory(itemsPresenterType);
        OS.FrameworkElementFactory_AppendChild(borderNode, scrollViewerNode);
        OS.FrameworkElementFactory_AppendChild(scrollViewerNode, itemsPresenterNode);
        int scrollStyle = this.createDotNetString(scrollViewerStyle, false);
        int stringReader = OS.gcnew_StringReader(scrollStyle);
        int xmlReader = OS.XmlReader_Create(stringReader);
        int xamlStyle = OS.XamlReader_Load(xmlReader);
        int styleProperty = OS.FrameworkElement_StyleProperty();
        OS.FrameworkElementFactory_SetValue(scrollViewerNode, styleProperty, xamlStyle);
        int columnsProperty = OS.GridViewRowPresenterBase_ColumnsProperty();
        OS.FrameworkElementFactory_SetValue(scrollViewerNode, columnsProperty, this.gvColumns);
        OS.FrameworkTemplate_VisualTree(template, borderNode);
        OS.GCHandle_Free(brushProperty);
        OS.GCHandle_Free(thicknessProperty);
        OS.GCHandle_Free(brushBinding);
        OS.GCHandle_Free(thicknessBinding);
        OS.GCHandle_Free(scrollStyle);
        OS.GCHandle_Free(stringReader);
        OS.GCHandle_Free(xmlReader);
        OS.GCHandle_Free(styleProperty);
        OS.GCHandle_Free(columnsProperty);
        OS.GCHandle_Free(xamlStyle);
        OS.GCHandle_Free(scrollViewerType);
        OS.GCHandle_Free(scrollViewerName);
        OS.GCHandle_Free(scrollViewerNode);
        OS.GCHandle_Free(borderType);
        OS.GCHandle_Free(borderNode);
        OS.GCHandle_Free(itemsPresenterType);
        OS.GCHandle_Free(itemsPresenterNode);
        return template;
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = (this.style & 4) != 0 ? OS.gcnew_TreeView() : OS.gcnew_SWTTreeView(this.jniRef);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.Canvas_SetLeft(this.handle, 0.0);
        OS.Canvas_SetTop(this.handle, 0.0);
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.handle);
        OS.GCHandle_Free(children);
    }

    int createHeaderTemplate(int columnJniRef) {
        int template = OS.gcnew_DataTemplate();
        int stackPanelType = OS.StackPanel_typeid();
        int stackPanelName = this.createDotNetString(CONTENTPANEL_PART_NAME, false);
        int stackPanelNode = OS.gcnew_FrameworkElementFactory(stackPanelType, stackPanelName);
        OS.GCHandle_Free(stackPanelName);
        OS.GCHandle_Free(stackPanelType);
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(textType);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(imageType);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        OS.GCHandle_Free(thickness);
        OS.GCHandle_Free(marginProperty);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(stackPanelNode, orientationProperty, 0);
        OS.GCHandle_Free(orientationProperty);
        int stretchProperty = OS.Image_StretchProperty();
        OS.FrameworkElementFactory_SetValueStretch(imageNode, stretchProperty, 0);
        OS.GCHandle_Free(stretchProperty);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, imageNode);
        OS.GCHandle_Free(imageNode);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, textNode);
        OS.GCHandle_Free(textNode);
        OS.FrameworkTemplate_VisualTree(template, stackPanelNode);
        OS.GCHandle_Free(stackPanelNode);
        return template;
    }

    void createItem(TreeColumn column, int index) {
        int template;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            this.gvColumns = OS.gcnew_GridViewColumnCollection();
            if (this.gvColumns == 0) {
                this.error(2);
            }
            template = this.createControlTemplate();
            OS.Control_Template(this.handle, template);
            OS.GCHandle_Free(template);
            this.updateHeaderVisibility();
        }
        column.createWidget();
        template = this.createHeaderTemplate(column.jniRef);
        OS.GridViewColumn_HeaderTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        template = this.createCellTemplate(index);
        OS.GridViewColumn_CellTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        if (this.columnCount == 0) {
            OS.GridViewColumnCollection_Clear(this.gvColumns);
        }
        OS.GridViewColumnCollection_Insert(this.gvColumns, index, column.handle);
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null) {
                item.columnAdded(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        if (this.columns == null) {
            this.columns = new TreeColumn[4];
        }
        if (this.columns.length == this.columnCount) {
            TreeColumn[] newColumns = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            this.columns = newColumns;
        }
        this.columns[this.columnCount] = column;
        ++this.columnCount;
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        int itemCount;
        int n = itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        item.createWidget();
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        OS.ItemCollection_Insert(items, index, item.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (itemCount == count) {
            this.error(14);
        }
        if (parentItem != null) {
            ++parentItem.itemCount;
        } else {
            ++this.itemCount;
        }
    }

    void createWidget() {
        super.createWidget();
        this.headerTemplate = this.createCellTemplate(0);
        int brush = OS.Brushes_Transparent();
        OS.Control_Background(this.handle, brush);
        OS.GCHandle_Free(brush);
    }

    int defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    int defaultForeground() {
        return this.display.getSystemColor((int)24).handle;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    public void deselect(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if ((this.style & 4) != 0) {
            this.ignoreSelection = true;
            OS.TreeViewItem_IsSelected(item.handle, false);
            this.ignoreSelection = false;
            return;
        }
        this.ignoreSelection = true;
        this.setIsSelectionActiveProperty(true);
        OS.TreeViewItem_IsSelected(item.handle, false);
        this.setIsSelectionActiveProperty(false);
        this.ignoreSelection = false;
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int tvItem = OS.TreeView_SelectedItem(this.handle);
            if (tvItem != 0) {
                this.ignoreSelection = true;
                OS.TreeViewItem_IsSelected(tvItem, false);
                this.ignoreSelection = false;
                OS.GCHandle_Free(tvItem);
            }
        } else {
            int items = OS.ItemsControl_Items(this.handle);
            int itemCount = OS.ItemCollection_Count(items);
            boolean[] selecting = new boolean[1];
            int i = 0;
            while (i < itemCount) {
                int item = OS.ItemCollection_GetItemAt(items, i);
                this.fixSelection(item, null, null, selecting);
                OS.GCHandle_Free(item);
                ++i;
            }
            OS.GCHandle_Free(items);
        }
    }

    void destroyItem(TreeColumn column) {
        int index = OS.GridViewColumnCollection_IndexOf(this.gvColumns, column.handle);
        boolean removed = OS.GridViewColumnCollection_Remove(this.gvColumns, column.handle);
        if (!removed) {
            this.error(15);
        }
        int arrayIndex = -1;
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn tc = this.columns[i];
            if (tc.equals(column)) {
                arrayIndex = i;
                break;
            }
            ++i;
        }
        --this.columnCount;
        this.columns[arrayIndex] = null;
        if (arrayIndex < this.columnCount) {
            System.arraycopy(this.columns, arrayIndex + 1, this.columns, arrayIndex, this.columnCount - arrayIndex);
        }
        if (this.columnCount == 0) {
            OS.GCHandle_Free(this.gvColumns);
            this.gvColumns = 0;
            int templateProperty = OS.Control_TemplateProperty();
            OS.DependencyObject_ClearValue(this.handle, templateProperty);
            OS.GCHandle_Free(templateProperty);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i2 = 0;
        while (i2 < this.itemCount) {
            TreeItem item = this.getItem(items, i2, false);
            if (item != null) {
                item.columnRemoved(index);
            }
            ++i2;
        }
        OS.GCHandle_Free(items);
    }

    void destroyItem(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        int itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        OS.ItemCollection_Remove(items, item.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (count == itemCount) {
            this.error(15);
        }
        if (parentItem != null) {
            --parentItem.itemCount;
        } else {
            --this.itemCount;
        }
    }

    int findScrollViewer(int current, int scrollViewerType) {
        if (this.columnCount != 0) {
            int template = OS.Control_Template(this.handle);
            int scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false);
            int scrollViewer = OS.FrameworkTemplate_FindName(template, scrollViewerName, this.handle);
            OS.GCHandle_Free(scrollViewerName);
            OS.GCHandle_Free(template);
            return scrollViewer;
        }
        return super.findScrollViewer(current, scrollViewerType);
    }

    int findPartOfType(int source, int type) {
        if (OS.Type_IsInstanceOfType(type, source)) {
            return source;
        }
        int parent = OS.VisualTreeHelper_GetParent(source);
        if (parent == 0) {
            return 0;
        }
        int result = this.findPartOfType(parent, type);
        if (result != parent) {
            OS.GCHandle_Free(parent);
        }
        return result;
    }

    void fixScrollbarVisibility() {
        int typeid = OS.ScrollViewer_typeid();
        int scrolledHandle = this.findScrollViewer(this.handle, typeid);
        OS.ScrollViewer_SetHorizontalScrollBarVisibility(scrolledHandle, 3);
        OS.ScrollViewer_SetVerticalScrollBarVisibility(scrolledHandle, 3);
        OS.GCHandle_Free(scrolledHandle);
        OS.GCHandle_Free(typeid);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (this.gvColumns == 0) {
            return 0;
        }
        int column = OS.GridViewColumnCollection_default(this.gvColumns, 0);
        int height = 0;
        int header = OS.GridViewColumn_Header(column);
        if (header != 0) {
            height = (int)OS.FrameworkElement_ActualHeight(header);
            if (height == 0) {
                this.updateLayout(header);
                height = (int)OS.FrameworkElement_ActualHeight(header);
            }
            OS.GCHandle_Free(header);
        }
        OS.GCHandle_Free(column);
        OS.GCHandle_Free(this.gvColumns);
        return height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        if (this.gvColumns == 0) {
            return false;
        }
        int column = OS.GridViewColumnCollection_default(this.gvColumns, 0);
        int header = OS.GridViewColumn_Header(column);
        boolean visible = OS.UIElement_Visibility(header) == 0;
        OS.GCHandle_Free(header);
        OS.GCHandle_Free(column);
        return visible;
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        i = 0;
        while (i < order.length) {
            TreeColumn column = this.columns[i];
            int index = OS.IList_IndexOf(this.gvColumns, column.handle);
            order[index] = i++;
        }
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        int i = 0;
        while (i < result.length) {
            result[i] = this.columns[i];
            ++i;
        }
        return result;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TreeItem treeItem = this.getItem(items, index, true);
        OS.GCHandle_Free(items);
        return treeItem;
    }

    TreeItem getItem(int items, int index, boolean create) {
        int item = OS.ItemCollection_GetItemAt(items, index);
        TreeItem result = this.getItem(item, create);
        OS.GCHandle_Free(item);
        return result;
    }

    TreeItem getItem(int item, boolean create) {
        int tag = OS.FrameworkElement_Tag(item);
        if (tag != 0) {
            int contentValue = OS.IntPtr_ToInt32(tag);
            OS.GCHandle_Free(tag);
            return (TreeItem)OS.JNIGetObject(contentValue);
        }
        if (create) {
            int itemHandle = OS.GCHandle_Alloc(item);
            int parentHandle = OS.FrameworkElement_Parent(item);
            TreeItem parentItem = null;
            if (!OS.Object_Equals(parentHandle, this.handle)) {
                parentItem = (TreeItem)this.display.getWidget(parentHandle);
            }
            OS.GCHandle_Free(parentHandle);
            return new TreeItem(this, parentItem, 0, 0, itemHandle);
        }
        return null;
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int pt = OS.gcnew_Point(point.x, point.y);
        int input = OS.UIElement_InputHitTest(this.handle, pt);
        OS.GCHandle_Free(pt);
        if (input == 0) {
            return null;
        }
        Widget widget = this.display.getWidget(input);
        OS.GCHandle_Free(input);
        if (widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            return 16;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, 0);
        double height = OS.FrameworkElement_ActualHeight(item);
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
        return height != 0.0 ? (int)height : 16;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i, true);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return false;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        TreeItem[] result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int item = OS.TreeView_SelectedItem(this.handle);
            if (item == 0) {
                return new TreeItem[0];
            }
            result = new TreeItem[]{(TreeItem)this.display.getWidget(item)};
            OS.GCHandle_Free(item);
        } else {
            result = this.getSelectedItems(this.handle, new TreeItem[4], new int[1]);
        }
        return result;
    }

    TreeItem[] getSelectedItems(int itemsControl, TreeItem[] selectedItems, int[] nextIndex) {
        int items = OS.ItemsControl_Items(itemsControl);
        int count = OS.ItemCollection_Count(items);
        int i = 0;
        while (i < count) {
            int item = OS.ItemCollection_GetItemAt(items, i);
            boolean selected = OS.TreeViewItem_IsSelected(item);
            if (selected) {
                if (nextIndex[0] == selectedItems.length) {
                    TreeItem[] newArray = new TreeItem[selectedItems.length + 4];
                    System.arraycopy(selectedItems, 0, newArray, 0, selectedItems.length);
                    selectedItems = newArray;
                }
                int n = nextIndex[0];
                nextIndex[0] = n + 1;
                selectedItems[n] = this.getItem(item, true);
            }
            if (OS.TreeViewItem_IsExpanded(item)) {
                selectedItems = this.getSelectedItems(item, selectedItems, nextIndex);
            }
            OS.GCHandle_Free(item);
            ++i;
        }
        OS.GCHandle_Free(items);
        if (selectedItems.length != nextIndex[0]) {
            TreeItem[] newArray = new TreeItem[nextIndex[0]];
            System.arraycopy(selectedItems, 0, newArray, 0, nextIndex[0]);
            selectedItems = newArray;
        }
        return selectedItems;
    }

    public int getSelectionCount() {
        int result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int item = OS.TreeView_SelectedItem(this.handle);
            result = item == 0 ? 0 : 1;
            OS.GCHandle_Free(item);
        } else {
            TreeItem[] selectedItems = this.getSelectedItems(this.handle, new TreeItem[4], new int[1]);
            result = selectedItems.length;
        }
        return result;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return null;
    }

    public int getSortDirection() {
        this.checkWidget();
        return 0;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        return null;
    }

    boolean hasItems() {
        return true;
    }

    void HandleChecked(int sender, int e) {
        int checkbox;
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int origsource = OS.RoutedEventArgs_OriginalSource(e);
        int typeid = OS.CheckBox_typeid();
        boolean isCheckBox = OS.Type_IsInstanceOfType(typeid, origsource);
        OS.GCHandle_Free(typeid);
        OS.GCHandle_Free(origsource);
        if (!isCheckBox) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TreeItem item = (TreeItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (item.grayed && (checkbox = item.findPart(0, CHECKBOX_PART_NAME)) != 0) {
            OS.ToggleButton_IsCheckedNullSetter(checkbox);
            OS.GCHandle_Free(checkbox);
        }
        item.checked = true;
        item.updateCheck();
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void HandleCollapsed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        if (OS.ItemsControl_HasItems(source)) {
            TreeItem item = (TreeItem)this.display.getWidget(source);
            int items = OS.ItemsControl_Items(item.handle);
            int count = OS.ItemCollection_Count(items);
            boolean[] selecting = new boolean[1];
            int i = 0;
            while (i < count) {
                int child = OS.ItemCollection_GetItemAt(items, i);
                this.fixSelection(child, null, null, selecting);
                OS.GCHandle_Free(child);
                ++i;
            }
            OS.GCHandle_Free(items);
            Event event = new Event();
            event.item = item;
            this.sendEvent(18, event);
        }
        OS.GCHandle_Free(source);
    }

    void HandleExpanded(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        if (OS.ItemsControl_HasItems(source)) {
            Event event = new Event();
            event.item = (TreeItem)this.display.getWidget(source);
            this.sendEvent(17, event);
        }
        OS.GCHandle_Free(source);
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 6) {
            int source = OS.RoutedEventArgs_OriginalSource(e);
            Widget widget = this.display.getWidget(source);
            OS.GCHandle_Free(source);
            if (widget instanceof TreeItem) {
                Event event = new Event();
                event.item = (TreeItem)widget;
                this.postEvent(14, event);
            }
        }
        if (key == 117 || key == 116) {
            this.shiftDown = true;
        }
        if (key == 119 || key == 118) {
            this.ctrlDown = true;
        }
    }

    void HandlePreviewKeyUp(int sender, int e) {
        super.HandlePreviewKeyUp(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 117 || key == 116) {
            this.shiftDown = false;
        }
        if (key == 119 || key == 118) {
            this.ctrlDown = false;
        }
    }

    void HandleLoaded(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateHeaderVisibility();
    }

    void HandlePreviewMouseDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_OriginalSource(e);
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget instanceof TreeItem) {
            Event event = new Event();
            event.item = (TreeItem)widget;
            this.postEvent(14, event);
        }
        if (this.hooks(14)) {
            OS.RoutedEventArgs_Handled(e, true);
        }
    }

    void HandlePreviewMouseDown(int sender, int e) {
        super.HandlePreviewMouseDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.style & 4) != 0) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            int point = OS.MouseEventArgs_GetPosition(e, item.contentHandle);
            int input = OS.UIElement_InputHitTest(item.contentHandle, point);
            OS.GCHandle_Free(point);
            if (input != 0) {
                boolean selected;
                boolean rightClick;
                OS.GCHandle_Free(input);
                boolean bl = rightClick = OS.MouseEventArgs_RightButton(e) == 1;
                if (rightClick && (this.ctrlDown || this.shiftDown)) {
                    return;
                }
                if (this.ctrlDown) {
                    selected = OS.TreeViewItem_IsSelected(item.handle);
                    if (widget.equals(this.lastSelection)) {
                        OS.TreeViewItem_IsSelected(item.handle, !selected);
                    } else {
                        if (selected) {
                            this.unselect = item;
                        }
                        if (this.lastSelection != null && OS.TreeViewItem_IsSelected(this.lastSelection.handle)) {
                            this.reselect = this.lastSelection;
                        }
                    }
                }
                if (!this.shiftDown && !this.ctrlDown) {
                    selected = OS.TreeViewItem_IsSelected(item.handle);
                    if (selected && rightClick) {
                        return;
                    }
                    this.deselectAll();
                    OS.TreeViewItem_IsSelected(item.handle, true);
                }
            }
            this.lastSelection = item;
        }
    }

    void HandleSelectedItemChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int selectedItem = OS.TreeView_SelectedItem(this.handle);
        if (selectedItem == 0) {
            return;
        }
        TreeItem item = (TreeItem)this.display.getWidget(selectedItem);
        OS.GCHandle_Free(selectedItem);
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
    }

    void HandleUnchecked(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int origsource = OS.RoutedEventArgs_OriginalSource(e);
        int typeid = OS.CheckBox_typeid();
        boolean isCheckBox = OS.Type_IsInstanceOfType(typeid, origsource);
        OS.GCHandle_Free(typeid);
        OS.GCHandle_Free(origsource);
        if (!isCheckBox) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TreeItem item = (TreeItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        item.checked = false;
        item.updateCheck();
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleLoaded");
        if (handler == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Loaded(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedPropertyChangedEventHandlerObject(this.jniRef, "HandleSelectedItemChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.TreeView_SelectedItemChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandlePreviewMouseDoubleClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.Control_PreviewMouseDoubleClick(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleExpanded");
        if (handler == 0) {
            this.error(2);
        }
        int event = OS.TreeViewItem_ExpandedEvent();
        OS.UIElement_AddHandler(this.handle, event, handler, false);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleCollapsed");
        if (handler == 0) {
            this.error(2);
        }
        event = OS.TreeViewItem_CollapsedEvent();
        OS.UIElement_AddHandler(this.handle, event, handler, false);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        if ((this.style & 0x20) != 0) {
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleChecked");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_CheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler, false);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUnchecked");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_UncheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler, false);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
        }
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (this.gvColumns == 0) {
            return -1;
        }
        int index = OS.GridViewColumnCollection_IndexOf(this.gvColumns, column.handle);
        return index;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.handle);
        OS.GCHandle_Free(items);
        return index;
    }

    void OnRender(int source, int dc) {
        int type = OS.TreeViewItem_typeid();
        int itemHandle = this.findPartOfType(source, type);
        OS.GCHandle_Free(type);
        TreeItem item = this.getItem(itemHandle, true);
        OS.GCHandle_Free(itemHandle);
        if ((item.cached || (this.style & 0x10000000) == 0) && item.contentHandle != 0) {
            return;
        }
        this.checkData(item);
        if (item.contentHandle == 0) {
            item.contentHandle = item.findContentPresenter();
        }
        int columns = this.columnCount == 0 ? 1 : this.columnCount;
        item.updateCheck();
        int i = 0;
        while (i < columns) {
            item.updateText(i);
            item.updateImage(i);
            item.updateBackground(i);
            item.updateForeground(i);
            item.updateFont(i);
            ++i;
        }
    }

    void OnSelectedItemChanged(int args) {
        int newItemRef = OS.RoutedPropertyChangedEventArgs_NewValue(args);
        TreeItem newItem = null;
        if (newItemRef != 0) {
            int unsetValue = OS.DependencyProperty_UnsetValue();
            if (!OS.Object_Equals(newItemRef, unsetValue)) {
                newItem = this.getItem(newItemRef, false);
            }
            OS.GCHandle_Free(newItemRef);
            OS.GCHandle_Free(unsetValue);
            newItemRef = 0;
        }
        this.setIsSelectionActiveProperty(true);
        if (!this.shiftDown && !this.ctrlDown) {
            this.deselectAll();
            if (newItem != null) {
                OS.TreeViewItem_IsSelected(newItem.handle, true);
            }
            this.anchor = newItem;
        } else if (this.shiftDown) {
            this.deselectAll();
            if (this.anchor == null || this.anchor == newItem) {
                if (newItem != null) {
                    OS.TreeViewItem_IsSelected(newItem.handle, true);
                }
                this.anchor = newItem;
            } else {
                int zero = OS.gcnew_Point(0.0, 0.0);
                int point = OS.UIElement_TranslatePoint(this.anchor.handle, zero, newItem.handle);
                OS.GCHandle_Free(zero);
                boolean down = OS.Point_Y(point) < 0.0;
                OS.GCHandle_Free(point);
                TreeItem from = down ? this.anchor : newItem;
                TreeItem to = down ? newItem : this.anchor;
                int items = OS.ItemsControl_Items(this.handle);
                int itemCount = OS.ItemCollection_Count(items);
                boolean[] selecting = new boolean[1];
                int i = 0;
                while (i < itemCount) {
                    int item = OS.ItemCollection_GetItemAt(items, i);
                    this.fixSelection(item, from, to, selecting);
                    OS.GCHandle_Free(item);
                    ++i;
                }
                OS.GCHandle_Free(items);
            }
        } else {
            if (this.unselect != null) {
                OS.TreeViewItem_IsSelected(this.unselect.handle, false);
                this.unselect = null;
            }
            if (this.reselect != null) {
                OS.TreeViewItem_IsSelected(this.reselect.handle, true);
                this.reselect = null;
            }
            this.anchor = newItem;
        }
        this.setIsSelectionActiveProperty(false);
    }

    private void fixSelection(int tvItem, TreeItem from, TreeItem to, boolean[] selecting) {
        if (selecting[0]) {
            OS.TreeViewItem_IsSelected(tvItem, true);
            if (to != null && OS.Object_Equals(tvItem, to.handle)) {
                selecting[0] = false;
            }
        } else {
            if (from != null && OS.Object_Equals(tvItem, from.handle)) {
                selecting[0] = true;
            }
            OS.TreeViewItem_IsSelected(tvItem, selecting[0]);
        }
        if (OS.TreeViewItem_IsExpanded(tvItem)) {
            int items = OS.ItemsControl_Items(tvItem);
            int itemCount = OS.ItemCollection_Count(items);
            int i = 0;
            while (i < itemCount) {
                int tvChild = OS.ItemCollection_GetItemAt(items, i);
                this.fixSelection(tvChild, from, to, selecting);
                OS.GCHandle_Free(tvChild);
                ++i;
            }
            OS.GCHandle_Free(items);
        }
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (column != null && !column.isDisposed()) {
                column.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.gvColumns != 0) {
            OS.GCHandle_Free(this.gvColumns);
        }
        this.gvColumns = 0;
        if (this.headerTemplate != 0) {
            OS.GCHandle_Free(this.headerTemplate);
        }
        this.headerTemplate = 0;
        OS.GCHandle_Free(this.parentingHandle);
        this.parentingHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.columns = null;
    }

    public void removeAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(items);
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            OS.FrameworkElement_Width(this.handle, width);
            OS.FrameworkElement_Height(this.handle, height);
        }
        return result;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.setItemCount(null, count);
    }

    void setItemCount(TreeItem parentItem, int count) {
        int itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        if ((count = Math.max(0, count)) == itemCount) {
            return;
        }
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int index = itemCount - 1;
        int items = OS.ItemsControl_Items(parentHandle);
        while (index >= count) {
            TreeItem item = this.getItem(items, index, false);
            if (item != null) {
                if (!item.isDisposed()) {
                    item.release(true);
                }
            } else {
                OS.ItemCollection_RemoveAt(items, index);
            }
            --index;
        }
        if (OS.ItemCollection_Count(items) > count) {
            this.error(15);
        }
        if ((this.style & 0x10000000) != 0) {
            int i = itemCount;
            while (i < count) {
                int item = OS.gcnew_TreeViewItem();
                if (item == 0) {
                    this.error(2);
                }
                if (this.columnCount != 0) {
                    int headerHandle = OS.gcnew_SWTTreeViewRowPresenter(this.handle);
                    if (headerHandle == 0) {
                        this.error(2);
                    }
                    OS.GridViewRowPresenterBase_Columns(headerHandle, this.gvColumns);
                    OS.HeaderedItemsControl_Header(item, headerHandle);
                    OS.GCHandle_Free(headerHandle);
                } else {
                    OS.TreeViewItem_HeaderTemplate(item, this.headerTemplate);
                }
                OS.ItemCollection_Add(items, item);
                OS.GCHandle_Free(item);
                ++i;
            }
        } else {
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, parentItem, 0, i, 0);
                ++i;
            }
        }
        itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (itemCount != count) {
            this.error(14);
        }
        if (parentItem != null) {
            parentItem.itemCount = itemCount;
        } else {
            this.itemCount = itemCount;
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
    }

    public void select(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if ((this.style & 4) != 0) {
            this.ignoreSelection = true;
            OS.TreeViewItem_IsSelected(item.handle, true);
            this.ignoreSelection = false;
            return;
        }
        this.ignoreSelection = true;
        this.setIsSelectionActiveProperty(true);
        OS.TreeViewItem_IsSelected(item.handle, true);
        this.setIsSelectionActiveProperty(false);
        this.ignoreSelection = false;
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int itemCount = OS.ItemCollection_Count(items);
        boolean[] selecting = new boolean[]{true};
        this.setIsSelectionActiveProperty(true);
        int i = 0;
        while (i < itemCount) {
            int item = OS.ItemCollection_GetItemAt(items, i);
            this.fixSelection(item, null, null, selecting);
            OS.GCHandle_Free(item);
            ++i;
        }
        this.setIsSelectionActiveProperty(false);
        OS.GCHandle_Free(items);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (!reorder) {
            return;
        }
        i = 0;
        while (i < order.length) {
            TreeColumn column = this.columns[order[i]];
            int index = OS.IList_IndexOf(this.gvColumns, column.handle);
            if (index != i) {
                OS.ObservableCollectionGridViewColumn_Move(this.gvColumns, index, i);
            }
            ++i;
        }
    }

    void setFont(int font, double size) {
        if (font != 0) {
            int fontFamily = OS.Typeface_FontFamily(font);
            int style = OS.Typeface_Style(font);
            int weight = OS.Typeface_Weight(font);
            int stretch = OS.Typeface_Stretch(font);
            OS.Control_FontFamily(this.handle, fontFamily);
            OS.Control_FontStyle(this.handle, style);
            OS.Control_FontWeight(this.handle, weight);
            OS.Control_FontStretch(this.handle, stretch);
            OS.Control_FontSize(this.handle, size);
            OS.GCHandle_Free(fontFamily);
            OS.GCHandle_Free(style);
            OS.GCHandle_Free(weight);
            OS.GCHandle_Free(stretch);
        } else {
            int property = OS.Control_FontFamilyProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStyleProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontWeightProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontStretchProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
            property = OS.Control_FontSizeProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        this.headerVisibility = (byte)(show ? 0 : 2);
        this.updateHeaderVisibility();
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.getColumn(i);
            column.updateImage();
            column.updateText();
            ++i;
        }
    }

    void setIsSelectionActiveProperty(boolean active) {
        int treeType = OS.Object_GetType(this.handle);
        int propertyName = this.createDotNetString("IsSelectionChangeActive", false);
        int property = OS.Type_GetProperty(treeType, propertyName, 36);
        OS.GCHandle_Free(treeType);
        OS.GCHandle_Free(propertyName);
        OS.PropertyInfo_SetValueBoolean(property, this.handle, active, 0);
        OS.GCHandle_Free(property);
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        TreeItem item;
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        int i = 0;
        while (i < items.length) {
            item = items[i];
            if (item != null && item.isDisposed()) {
                this.error(24);
            }
            ++i;
        }
        this.deselectAll();
        this.ignoreSelection = true;
        if ((this.style & 4) != 0) {
            TreeItem select = items[0];
            if (select != null) {
                OS.TreeViewItem_IsSelected(items[0].handle, true);
            }
        } else {
            this.setIsSelectionActiveProperty(true);
            i = 0;
            while (i < length) {
                item = items[i];
                if (item != null) {
                    OS.TreeViewItem_IsSelected(item.handle, true);
                }
                ++i;
            }
            this.setIsSelectionActiveProperty(false);
        }
        this.ignoreSelection = false;
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int parent = OS.FrameworkElement_Parent(item.handle);
        while (!OS.Object_Equals(parent, this.handle)) {
            OS.TreeViewItem_IsExpanded(parent, true);
            int newParent = OS.FrameworkElement_Parent(parent);
            OS.GCHandle_Free(parent);
            parent = newParent;
        }
        OS.GCHandle_Free(parent);
        OS.FrameworkElement_BringIntoView(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int item = OS.TreeView_SelectedItem(this.handle);
        if (item != 0) {
            OS.FrameworkElement_BringIntoView(item);
            OS.GCHandle_Free(item);
        }
    }

    int topHandle() {
        return this.parentingHandle;
    }

    void updateHeaderVisibility() {
        int scrollViewerName;
        int template = OS.Control_Template(this.handle);
        int scrollViewer = OS.FrameworkTemplate_FindName(template, scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false), this.handle);
        if (scrollViewer != 0) {
            int headerName;
            int scrollViewerTemplate = OS.Control_Template(scrollViewer);
            int header = OS.FrameworkTemplate_FindName(scrollViewerTemplate, headerName = this.createDotNetString(HEADER_PART_NAME, false), scrollViewer);
            if (header != 0) {
                OS.UIElement_Visibility(header, this.headerVisibility);
                OS.GCHandle_Free(header);
            }
            OS.GCHandle_Free(scrollViewerTemplate);
            OS.GCHandle_Free(headerName);
            OS.GCHandle_Free(scrollViewer);
        }
        OS.GCHandle_Free(scrollViewerName);
        OS.GCHandle_Free(template);
    }
}

