/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    static final int IMAGE_PART = 0;
    static final int TEXT_PART = 1;
    int headerHandle;
    int stringHandle;
    boolean moveable;
    boolean resizable = true;
    Table parent;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        this.handle = OS.gcnew_GridViewColumn();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.headerHandle = OS.gcnew_GridViewColumnHeader();
        OS.GridViewColumn_Header(this.handle, this.headerHandle);
    }

    void deregister() {
        this.display.removeWidget(this.headerHandle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int findPart(String part) {
        this.updateLayout(this.headerHandle);
        int headerTemplate = OS.Control_Template(this.headerHandle);
        int name = this.createDotNetString("HeaderContent", false);
        int contentPresenter = OS.FrameworkTemplate_FindName(headerTemplate, name, this.headerHandle);
        OS.GCHandle_Free(name);
        OS.GCHandle_Free(headerTemplate);
        if (contentPresenter == 0) {
            return 0;
        }
        int dataTemplate = OS.GridViewColumn_HeaderTemplate(this.handle);
        name = this.createDotNetString(part, false);
        int result = OS.FrameworkTemplate_FindName(dataTemplate, name, contentPresenter);
        OS.GCHandle_Free(contentPresenter);
        OS.GCHandle_Free(dataTemplate);
        OS.GCHandle_Free(name);
        return result;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        int strPtr = OS.FrameworkElement_ToolTip(this.headerHandle);
        String string = TableColumn.createJavaString(strPtr);
        OS.GCHandle_Free(strPtr);
        return string;
    }

    public int getWidth() {
        this.checkWidget();
        return (int)OS.GridViewColumn_ActualWidth(this.handle);
    }

    void HandleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.postEvent(13);
    }

    void HandleLoaded(int sender, int e) {
        if (this.isDisposed()) {
            return;
        }
        this.updateImage();
        this.updateText();
    }

    void HandleMouseDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.postEvent(14);
    }

    void HandleSizeChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.sendEvent(11);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleLoaded");
        if (handler == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Loaded(this.headerHandle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
        if (handler == 0) {
            this.error(2);
        }
        int event = OS.ButtonBase_ClickEvent();
        OS.UIElement_AddHandler(this.headerHandle, event, handler, false);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleMouseDoubleClick");
        if (handler == 0) {
            this.error(2);
        }
        event = OS.Control_MouseDoubleClickEvent();
        OS.UIElement_AddHandler(this.headerHandle, event, handler, false);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleSizeChanged");
        if (handler == 0) {
            this.error(2);
        }
        event = OS.FrameworkElement_SizeChangedEvent();
        OS.UIElement_AddHandler(this.headerHandle, event, handler, false);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
    }

    public void pack() {
        this.checkWidget();
        this.updateLayout(this.parent.handle);
        double width = 0.0;
        if (this.headerHandle != 0) {
            int size = OS.UIElement_DesiredSize(this.headerHandle);
            width = OS.Size_Width(size);
            OS.GCHandle_Free(size);
        }
        int columnIndex = this.parent.indexOf(this);
        int items = OS.ItemsControl_Items(this.parent.handle);
        int i = 0;
        while (i < this.parent.itemCount) {
            TableItem item = this.parent.getItem(items, i, false);
            if (item != null) {
                width = Math.max(width, item.computeWidth(columnIndex));
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        OS.GridViewColumn_Width(this.handle, width);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        OS.GCHandle_Free(this.headerHandle);
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.stringHandle != 0) {
            OS.GCHandle_Free(this.stringHandle);
        }
        this.stringHandle = 0;
    }

    void register() {
        this.display.addWidget(this.headerHandle, this);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        this.updateImage();
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.moveable = moveable;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    void setSortDirection(int direction) {
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string != null && string.length() == 0) {
            string = null;
        }
        int strPtr = this.createDotNetString(string, false);
        OS.FrameworkElement_ToolTip(this.headerHandle, strPtr);
        OS.GCHandle_Free(strPtr);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        this.updateLayout(this.parent.handle);
        OS.GridViewColumn_Width(this.handle, width);
    }

    void updateImage() {
        int part = this.findPart("SWT_PART_IMAGE");
        if (part == 0) {
            return;
        }
        OS.Image_Source(part, this.image == null ? 0 : this.image.handle);
        OS.GCHandle_Free(part);
    }

    void updateText() {
        int part = this.findPart("SWT_PART_TEXT");
        if (part == 0) {
            return;
        }
        int str = this.createDotNetString(this.text, false);
        OS.TextBlock_Text(part, str);
        OS.GCHandle_Free(str);
        OS.GCHandle_Free(part);
    }
}

