/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    static int checkStyle(int style) {
        return style &= 0xBFFFFFFF;
    }

    int getCaretHandle() {
        return 0;
    }

    Control[] _getChildren() {
        int parentHandle = this.parentingHandle();
        int elements = OS.Panel_Children(parentHandle);
        int count = OS.UIElementCollection_Count(elements);
        int caretHandle = this.getCaretHandle();
        if (caretHandle != 0) {
            --count;
        }
        Control[] children = new Control[count];
        int index = count - 1;
        if (count != 0) {
            int enumerator = OS.UIElementCollection_GetEnumerator(elements);
            while (OS.IEnumerator_MoveNext(enumerator)) {
                int current = OS.UIElementCollection_Current(enumerator);
                if (caretHandle != 0 && OS.Object_Equals(caretHandle, current)) {
                    OS.GCHandle_Free(current);
                    continue;
                }
                Widget widget = this.display.getWidget(current);
                if (widget != null && widget != this && widget instanceof Control) {
                    children[index--] = (Control)widget;
                }
                OS.GCHandle_Free(current);
            }
            OS.GCHandle_Free(enumerator);
        }
        OS.GCHandle_Free(elements);
        if (index == -1) {
            return children;
        }
        Control[] newChildren = new Control[count - index - 1];
        System.arraycopy(children, index + 1, newChildren, 0, newChildren.length);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    void addChild(Control control) {
        int parentHandle = this.parentingHandle();
        int children = OS.Panel_Children(parentHandle);
        int index = 0;
        if (parentHandle != this.handle && OS.UIElementCollection_Contains(children, this.handle)) {
            index = 1;
        }
        int topHandle = control.topHandle();
        OS.UIElementCollection_Insert(children, index, topHandle);
        OS.GCHandle_Free(children);
        OS.FrameworkElement_Width(topHandle, 0.0);
        OS.FrameworkElement_Height(topHandle, 0.0);
    }

    int backgoundProperty() {
        return OS.Panel_BackgroundProperty();
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x40;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                boolean bl = (this.state & 0x40) != 0;
                this.state &= 0xFFFFFFBF;
                size = this.layout.computeSize(this, wHint, hHint, changed |= bl);
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        this.state |= 2;
        if ((this.style & 0x300) == 0) {
            this.state |= 0x100;
        }
        boolean scrolled = (this.style & 0x300) != 0;
        this.createHandle(scrolled, false);
    }

    void createHandle(boolean scrolled, boolean menubar) {
        this.handle = OS.gcnew_SWTCanvas(this.jniRef);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.FrameworkElement_FocusVisualStyle(this.handle, 0);
        if ((this.style & 0x80000) == 0) {
            OS.UIElement_Focusable(this.handle, true);
        }
        if (scrolled || menubar) {
            int gridLength;
            this.scrolledHandle = OS.gcnew_Grid();
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            if ((gridLength = OS.gcnew_GridLength(1.0, 0)) == 0) {
                this.error(2);
            }
            int columnDefinitions = OS.Grid_ColumnDefinitions(this.scrolledHandle);
            int column0 = OS.gcnew_ColumnDefinition();
            if (column0 == 0) {
                this.error(2);
            }
            OS.ColumnDefinitionCollection_Add(columnDefinitions, column0);
            int column1 = OS.gcnew_ColumnDefinition();
            if (column1 == 0) {
                this.error(2);
            }
            OS.ColumnDefinition_Width(column1, gridLength);
            OS.ColumnDefinitionCollection_Add(columnDefinitions, column1);
            int rowDefinitions = OS.Grid_RowDefinitions(this.scrolledHandle);
            int row0 = OS.gcnew_RowDefinition();
            if (row0 == 0) {
                this.error(2);
            }
            OS.RowDefinition_Height(row0, gridLength);
            OS.RowDefinitionCollection_Add(rowDefinitions, row0);
            int row1 = OS.gcnew_RowDefinition();
            if (row1 == 0) {
                this.error(2);
            }
            OS.RowDefinitionCollection_Add(rowDefinitions, row1);
            int row2 = OS.gcnew_RowDefinition();
            if (row2 == 0) {
                this.error(2);
            }
            OS.RowDefinition_Height(row2, gridLength);
            OS.RowDefinitionCollection_Add(rowDefinitions, row2);
            OS.GCHandle_Free(column0);
            OS.GCHandle_Free(column1);
            OS.GCHandle_Free(row0);
            OS.GCHandle_Free(row1);
            OS.GCHandle_Free(row2);
            OS.GCHandle_Free(gridLength);
            OS.GCHandle_Free(columnDefinitions);
            OS.GCHandle_Free(rowDefinitions);
            int children = OS.Panel_Children(this.scrolledHandle);
            OS.UIElementCollection_Add(children, this.handle);
            OS.Grid_SetRow(this.handle, 1);
            OS.Grid_SetColumn(this.handle, 0);
            if ((this.style & 0x200) != 0) {
                int vScroll = OS.gcnew_ScrollBar();
                if (vScroll == 0) {
                    this.error(2);
                }
                OS.ScrollBar_Orientation(vScroll, 1);
                OS.RangeBase_Maximum(vScroll, 90.0);
                OS.RangeBase_LargeChange(vScroll, 10.0);
                OS.ScrollBar_ViewportSize(vScroll, 10.0);
                OS.Grid_SetRow(vScroll, 1);
                OS.Grid_SetColumn(vScroll, 1);
                OS.UIElementCollection_Add(children, vScroll);
                OS.GCHandle_Free(vScroll);
            }
            if ((this.style & 0x100) != 0) {
                int hScroll = OS.gcnew_ScrollBar();
                if (hScroll == 0) {
                    this.error(2);
                }
                OS.ScrollBar_Orientation(hScroll, 0);
                OS.RangeBase_Maximum(hScroll, 90.0);
                OS.RangeBase_LargeChange(hScroll, 10.0);
                OS.ScrollBar_ViewportSize(hScroll, 10.0);
                OS.Grid_SetRow(hScroll, 2);
                OS.Grid_SetColumn(hScroll, 0);
                OS.UIElementCollection_Add(children, hScroll);
                OS.GCHandle_Free(hScroll);
            }
            OS.GCHandle_Free(children);
        }
    }

    int defaultBackground() {
        if ((this.state & 2) != 0) {
            return OS.SystemColors_ControlColor;
        }
        return 0;
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            OS.UIElement_IsHitTestVisible(this.topHandle(), enabled);
        } else {
            OS.UIElement_IsEnabled(this.handle, enabled);
            OS.UIElement_IsHitTestVisible(this.parentingHandle(), enabled);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length != 0) {
                Menu[] newResult = new Menu[result.length + menuList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    void fixScrollbarVisibility() {
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    Point getLocation(Control child) {
        int topHandle = child.topHandle();
        int x = (int)OS.Canvas_GetLeft(topHandle);
        int y = (int)OS.Canvas_GetTop(topHandle);
        return new Point(x, y);
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.state & 2) != 0) {
            int key = OS.KeyEventArgs_Key(e);
            switch (key) {
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    OS.RoutedEventArgs_Handled(e, true);
                }
            }
        }
    }

    void HandlePreviewMouseDown(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        super.HandlePreviewMouseDown(sender, e);
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            int children = OS.Panel_Children(this.handle);
            int count = OS.UIElementCollection_Count(children);
            OS.GCHandle_Free(children);
            int caretHandle = this.getCaretHandle();
            if (caretHandle != 0) {
                --count;
            }
            if (count == 0) {
                OS.UIElement_Focus(this.handle);
            }
        }
    }

    void HandlePreviewTextInput(int sender, int e) {
        super.HandlePreviewTextInput(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        if ((this.state & 2) != 0) {
            OS.RoutedEventArgs_Handled(e, true);
        }
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(true, all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                this.error(32);
            }
            ++i;
        }
        int updateCount = 0;
        Composite[] update = new Composite[16];
        int i2 = 0;
        while (i2 < changed.length) {
            Control child = changed[i2];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout != null) {
                    composite.state |= 0x20;
                    if (!composite.layout.flushCache(child)) {
                        composite.state |= 0x40;
                    }
                }
                if (updateCount == update.length) {
                    Composite[] newUpdate = new Composite[update.length + 16];
                    System.arraycopy(update, 0, newUpdate, 0, update.length);
                    update = newUpdate;
                }
                int n = updateCount++;
                Composite composite2 = composite;
                update[n] = composite2;
                child = composite2;
                composite = child.parent;
            }
            ++i2;
        }
        i2 = updateCount - 1;
        while (i2 >= 0) {
            update[i2].updateLayout(true, false);
            --i2;
        }
    }

    void OnRender(int drawingContext) {
        if (this.isDisposed()) {
            return;
        }
        OS.SWTCanvas_Visual(this.handle, 0);
        if (this.display.ignoreRender) {
            this.display.addInvalidate(this);
            return;
        }
        if (!this.hooks(9)) {
            return;
        }
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        if (width != 0 && height != 0) {
            GCData data = new GCData();
            data.device = this.display;
            data.drawingContext = drawingContext;
            GC gc = GC.wpf_new(this, data);
            Event event = new Event();
            event.gc = gc;
            event.width = width;
            event.height = height;
            this.sendEvent(9, event);
            event.gc = null;
            gc.dispose();
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x20;
            if (changed) {
                this.state |= 0x40;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    int parentingHandle() {
        return this.handle;
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeChild(Control control) {
        int topHandle = control.topHandle();
        int parentHandle = this.parentingHandle();
        int children = OS.Panel_Children(parentHandle);
        OS.UIElementCollection_Remove(children, topHandle);
        OS.GCHandle_Free(children);
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resized() {
        super.resized();
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false, false);
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        int backgroundHandle = this.backgroundHandle();
        int property = this.backgroundProperty();
        int brush = OS.DependencyObject_GetValue(backgroundHandle, property);
        if (brush != 0) {
            int newBrush = OS.Freezable_Clone(brush);
            OS.Brush_Opacity(newBrush, (double)(alpha & 0xFF) / 255.0);
            OS.DependencyObject_SetValue(backgroundHandle, property, newBrush);
            OS.GCHandle_Free(brush);
            OS.GCHandle_Free(newBrush);
        }
        OS.GCHandle_Free(property);
    }

    void setBackgroundBrush(int brush) {
        if (brush != 0) {
            OS.Panel_Background(this.handle, brush);
        } else {
            int property = OS.Panel_BackgroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false, false);
        }
        return result;
    }

    void setClipping() {
        OS.UIElement_ClipToBounds(this.topHandle(), true);
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getVisible() && child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    void setFont(int font, double size) {
    }

    void setForegroundBrush(int brush) {
        OS.UIElement_InvalidateVisual(this.handle);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x80) != 0 || (this.state & 0x20) != 0)) {
                this.updateLayout(true, true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent != this) {
                    this.error(32);
                }
                ++i;
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                takeFocus = true;
            }
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child.translateMnemonic(event, control)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    int traversalCode(int key, int event) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, event);
    }

    boolean translateTraversal(int msg) {
        if ((this.state & 2) != 0 && (this.style & 0x1000000) != 0) {
            return false;
        }
        return super.translateTraversal(msg);
    }

    void updateBackgroundColor() {
        super.updateBackgroundColor();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            if ((children[i].state & 0x400) != 0) {
                children[i].updateBackgroundColor();
            }
            ++i;
        }
    }

    void updateBackgroundImage() {
        super.updateBackgroundImage();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            if ((children[i].state & 0x400) != 0) {
                children[i].updateBackgroundImage();
            }
            ++i;
        }
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].updateBackgroundMode();
            ++i;
        }
    }

    void updateFont(Font oldFont, Font newFont) {
        super.updateFont(oldFont, newFont);
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            if (!control.isDisposed()) {
                control.updateFont(oldFont, newFont);
            }
            ++i;
        }
    }

    void updateLayout(boolean resize, boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x80;
            return;
        }
        if ((this.state & 0x20) != 0) {
            boolean changed = (this.state & 0x40) != 0;
            this.state &= 0xFFFFFF9F;
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFFF7F;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(resize, all);
                ++i;
            }
        }
    }
}

