/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class IE
extends WebBrowser {
    int webBrowser;
    int host;
    int jniRef;
    boolean ignoreDispose;

    static {
        NativeClearSessions = new Runnable(){

            public void run() {
            }
        };
    }

    IE() {
    }

    public void create(Composite parent, int style) {
        this.host = OS.gcnew_WindowsFormsHost();
        if (this.host == 0) {
            SWT.error(2);
        }
        this.webBrowser = OS.gcnew_WebBrowser();
        if (this.webBrowser == 0) {
            SWT.error(2);
        }
        OS.WindowsFormsHost_Child(this.host, this.webBrowser);
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        OS.WebBrowser_ScriptErrorsSuppressed(this.webBrowser, true);
        int handler = OS.gcnew_WebBrowserNavigatingEventHandler(this.jniRef, "HandleNavigating");
        OS.WebBrowser_Navigating(this.webBrowser, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_WebBrowserProgressChangedEventHandler(this.jniRef, "HandleProgressChanged");
        OS.WebBrowser_ProgressChanged(this.webBrowser, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_EventHandler(this.jniRef, "HandleStatusTextChanged");
        OS.WebBrowser_StatusTextChanged(this.webBrowser, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_EventHandler(this.jniRef, "HandleDocumentTitleChanged");
        OS.WebBrowser_DocumentTitleChanged(this.webBrowser, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_WebBrowserDocumentCompletedEventHandler(this.jniRef, "HandleDocumentCompleted");
        OS.WebBrowser_DocumentCompleted(this.webBrowser, handler);
        OS.GCHandle_Free(handler);
        int parentHandle = this.browser.handle;
        int children = OS.Panel_Children(parentHandle);
        OS.UIElementCollection_Insert(children, 0, this.host);
        OS.GCHandle_Free(children);
        OS.FrameworkElement_Width(this.host, OS.FrameworkElement_Width(parentHandle));
        OS.FrameworkElement_Height(this.host, OS.FrameworkElement_Height(parentHandle));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (IE.this.ignoreDispose) {
                            IE.this.ignoreDispose = false;
                            break;
                        }
                        IE.this.ignoreDispose = true;
                        IE.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        OS.GCHandle_Free(IE.this.host);
                        OS.GCHandle_Free(IE.this.webBrowser);
                        OS.DeleteGlobalRef(IE.this.jniRef);
                        IE.this.jniRef = 0;
                        IE.this.webBrowser = 0;
                        IE.this.host = 0;
                        break;
                    }
                    case 11: {
                        OS.FrameworkElement_Width(IE.this.host, OS.FrameworkElement_Width(IE.this.browser.handle));
                        OS.FrameworkElement_Height(IE.this.host, OS.FrameworkElement_Height(IE.this.browser.handle));
                    }
                }
            }
        };
        this.browser.addListener(11, listener);
        this.browser.addListener(12, listener);
    }

    public boolean back() {
        return OS.WebBrowser_GoBack(this.webBrowser);
    }

    public boolean execute(String script) {
        return true;
    }

    public boolean forward() {
        return OS.WebBrowser_GoForward(this.webBrowser);
    }

    public String getText() {
        return "";
    }

    public String getUrl() {
        int uri = OS.WebBrowser_Url(this.webBrowser);
        String url = this.getUriString(uri);
        if (uri != 0) {
            OS.GCHandle_Free(uri);
        }
        return url;
    }

    String getUriString(int uri) {
        if (uri == 0) {
            return null;
        }
        int str = OS.Object_ToString(uri);
        int charArray = OS.String_ToCharArray(str);
        char[] chars = new char[OS.String_Length(str)];
        OS.memcpy(chars, charArray, chars.length * 2);
        OS.GCHandle_Free(charArray);
        String url = new String(chars);
        OS.GCHandle_Free(str);
        return url;
    }

    void HandleDocumentCompleted(int sender, int e) {
        if (this.webBrowser == 0) {
            return;
        }
        int uri = OS.WebBrowserDocumentCompletedEventArgs_Url(e);
        String url = this.getUriString(uri);
        if (uri != 0) {
            OS.GCHandle_Free(uri);
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changing(newEvent);
            ++i;
        }
        if (this.browser.isDisposed()) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        int i2 = 0;
        while (i2 < this.progressListeners.length) {
            this.progressListeners[i2].completed(progressEvent);
            ++i2;
        }
    }

    void HandleDocumentTitleChanged(int sender, int e) {
        if (this.webBrowser == 0) {
            return;
        }
        int str = OS.WebBrowser_DocumentTitle(this.webBrowser);
        String title = "";
        if (str != 0) {
            int charArray = OS.String_ToCharArray(str);
            char[] chars = new char[OS.String_Length(str)];
            OS.memcpy(chars, charArray, chars.length * 2);
            OS.GCHandle_Free(charArray);
            OS.GCHandle_Free(str);
            title = new String(chars);
        }
        TitleEvent newEvent = new TitleEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.title = title;
        int i = 0;
        while (i < this.titleListeners.length) {
            this.titleListeners[i].changed(newEvent);
            ++i;
        }
    }

    void HandleNavigating(int sender, int e) {
        if (this.webBrowser == 0) {
            return;
        }
        int uri = OS.WebBrowserNavigatingEventArgs_Url(e);
        String url = this.getUriString(uri);
        if (uri != 0) {
            OS.GCHandle_Free(uri);
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url;
        newEvent.doit = true;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changing(newEvent);
            ++i;
        }
    }

    void HandleProgressChanged(int sender, int e) {
        if (this.webBrowser == 0) {
            return;
        }
        long nProgress = OS.WebBrowserProgressChangedEventArgs_CurrentProgress(e);
        long nProgressMax = OS.WebBrowserProgressChangedEventArgs_MaximumProgress(e);
        if (nProgress != -1L) {
            ProgressEvent newEvent = new ProgressEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.current = (int)nProgress;
            newEvent.total = (int)nProgressMax;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    void HandleStatusTextChanged(int sender, int e) {
        if (this.webBrowser == 0) {
            return;
        }
        int str = OS.WebBrowser_StatusText(this.webBrowser);
        String text = "";
        if (str != 0) {
            int charArray = OS.String_ToCharArray(str);
            char[] chars = new char[OS.String_Length(str)];
            OS.memcpy(chars, charArray, chars.length * 2);
            OS.GCHandle_Free(charArray);
            OS.GCHandle_Free(str);
            text = new String(chars);
        }
        StatusTextEvent newEvent = new StatusTextEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.text = text;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(newEvent);
            ++i;
        }
    }

    public boolean isBackEnabled() {
        return OS.WebBrowser_CanGoBack(this.webBrowser);
    }

    public boolean isForwardEnabled() {
        return OS.WebBrowser_CanGoForward(this.webBrowser);
    }

    public void refresh() {
        OS.WebBrowser_Refresh(this.webBrowser);
    }

    public boolean setText(String html) {
        int state = OS.WebBrowser_ReadyState(this.webBrowser);
        if (state != 0 && state != 4) {
            OS.WebBrowser_Stop(this.webBrowser);
        }
        int length = html.length();
        char[] buffer = new char[length + 1];
        html.getChars(0, length, buffer, 0);
        int str = OS.gcnew_String(buffer);
        if (str == 0) {
            SWT.error(2);
        }
        OS.WebBrowser_DocumentText(this.webBrowser, str);
        OS.GCHandle_Free(str);
        return true;
    }

    public boolean setUrl(String url) {
        int state = OS.WebBrowser_ReadyState(this.webBrowser);
        if (state != 0 && state != 4) {
            OS.WebBrowser_Stop(this.webBrowser);
        }
        int length = url.length();
        char[] buffer = new char[length + 1];
        url.getChars(0, length, buffer, 0);
        int str = OS.gcnew_String(buffer);
        OS.WebBrowser_Navigate(this.webBrowser, str);
        OS.GCHandle_Free(str);
        return true;
    }

    public void stop() {
        OS.WebBrowser_Stop(this.webBrowser);
    }
}

