/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.stem;

import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.Stem;
import edu.mit.parsing.core.rep.stem.algorithm.IStemmer;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;

public class StemRep
extends AbstractRep {
    public static final String ID = "edu.mit.parsing.stem";
    private static final long serialVersionUID = 1L;
    private static IRep fInstance = null;

    public static IRep getInstance() {
        if (fInstance == null) {
            fInstance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return fInstance;
    }

    public StemRep() {
        super(IStem.class, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)CollocRep.getInstance());
        container.add((Object)POSRep.getInstance());
    }

    public String serialize(IData data) {
        IStem stem = (IStem)data;
        StringBuilder result = new StringBuilder();
        if (stem.getPOS() == null) {
            result.append(stem.getWord().getID());
        } else {
            result.append(stem.getPOS().getID());
        }
        result.append(' ');
        result.append(stem.getStem());
        return result.toString();
    }

    public Stem reconstitute(IHasPosition p, String data, IStoryModel model) {
        int idx = data.indexOf(32);
        if (idx == -1) {
            return this.legacyReconstitute(p, data, model);
        }
        String idStr = data.substring(0, idx);
        long id = -1L;
        try {
            id = Long.parseLong(idStr);
        }
        catch (NumberFormatException numberFormatException) {
            return this.legacyReconstitute(p, data, model);
        }
        String stem = data.substring(idx + 1).replace('_', ' ');
        IDesc desc = model.getData().getDescription(id);
        if (desc != null) {
            return new Stem(desc, stem);
        }
        return this.legacyReconstitute(p, stem, model);
    }

    public Stem legacyReconstitute(IHasPosition p, String stem, IStoryModel model) {
        IDesc token = null;
        IDescSet descs = model.getData().getDescriptions(TokenRep.getInstance()).matchSet(p);
        if (descs.isEmpty()) {
            descs = model.getData().getDescriptions(CollocRep.getInstance()).matchSet(p);
        }
        if (descs.size() == 1) {
            token = (IDesc)descs.first();
        }
        return token == null ? null : new Stem(token, stem);
    }

    public static String getStemmerID(IStoryModel model) {
        IDescFactory factory = model.getFactory(StemRep.getInstance());
        IConfiguration config = factory.getConfiguration();
        if (config == null) {
            return null;
        }
        return (String)config.get((Object)"stemmer");
    }

    public static IStemmer getStemmer(IStoryModel model) {
        String stemmerID = StemRep.getStemmerID(model);
        if (stemmerID == null) {
            return null;
        }
        IStemmer stemmer = (IStemmer)ParsingPlugin.getDefault().getStemmerManager().create(stemmerID);
        stemmer.init();
        return stemmer;
    }

    public static boolean isStemmable(IPosTag posTag) {
        ITag tag = posTag.getTag();
        if (tag.isProperNoun()) {
            return false;
        }
        if (tag == PennTag.MD) {
            return true;
        }
        return tag.isOpenClass();
    }
}

