/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.pos.problems;

import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousPOSProblem
extends StoryProblem {
    public static final String ID = "edu.mit.parsing.core.problem.ambiguousPOS";

    public AmbiguousPOSProblem(Collection<? extends IDesc> tags, String buildRuleID) {
        super(POSRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("Ambiguous Part of Speech");
        this.setDescs(tags);
        IDescSet posDescs = this.getDescs().getDescriptions(POSRep.getInstance());
        if (posDescs.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (IDesc posDesc : posDescs) {
            IPosTag tag = (IPosTag)posDesc.getData();
            this.getDescs().add((Object)tag.getWord());
        }
        IDescSet tokens = this.getDescs().getDescriptions(TokenRep.getInstance());
        IDescSet collocs = this.getDescs().getDescriptions(CollocRep.getInstance());
        HasPositionSet words = new HasPositionSet();
        words.addAll((Collection)tokens);
        words.addAll((Collection)collocs);
        if (words.isEmpty()) {
            throw new IllegalArgumentException();
        }
        IDesc d = (IDesc)words.first();
        this.setPosition((IHasPosition)d);
        if (words.size() > 1) {
            this.setDescription("There are " + tags.size() + " words with ambiguous part of speech assignments (only first shown)");
        } else {
            IBaseToken tok = (IBaseToken)d.getData();
            this.setDescription("The word '" + tok.getSurface() + "' is has " + posDescs.size() + " part of speech tags");
        }
    }
}

