/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.semantics.core.rep.timex3.ITimex3;
import edu.mit.semantics.core.rep.timex3.Timex3;
import edu.mit.semantics.core.rep.timex3.Timex3Rep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeTimexFeatureActionGroup
extends ActionGroup {
    private IMenuManager typeMenu;
    private IMenuManager funcMenu;
    private IMenuManager modMenu;

    public ChangeTimexFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        this(editor, provider, true);
    }

    public ChangeTimexFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.createActions(editor, provider, allMenus);
    }

    protected IRep getRep() {
        return Timex3Rep.getInstance();
    }

    protected void createActions(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.typeMenu = new MenuManager("&Type");
        this.typeMenu.setRemoveAllWhenShown(true);
        this.typeMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITimex3.Type[] typeArray = ITimex3.Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimex3.Type f = typeArray[n2];
                    manager.add((IAction)new ChangeTypeAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        if (!allMenus) {
            return;
        }
        this.modMenu = new MenuManager("&Modifier");
        this.modMenu.setRemoveAllWhenShown(true);
        this.modMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITimex3.Mod[] modArray = ITimex3.Mod.values();
                int n = modArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimex3.Mod f = modArray[n2];
                    manager.add((IAction)new ChangeModAction(f, editor, provider));
                    ++n2;
                }
            }
        });
        this.funcMenu = new MenuManager("&Function");
        this.funcMenu.setRemoveAllWhenShown(true);
        this.funcMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ITimex3.Function[] functionArray = ITimex3.Function.values();
                int n = functionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimex3.Function f = functionArray[n2];
                    manager.add((IAction)new ChangeFunctionAction(f, editor, provider));
                    ++n2;
                }
            }
        });
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        boolean all = obj != null && this.getRep().getDataFormat().isAssignableFrom(obj.getClass());
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (all || obj instanceof ITimex3.Type) {
            menu.appendToGroup("additions", (IContributionItem)this.typeMenu);
        }
        if ((all || obj instanceof ITimex3.Mod) && this.modMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.modMenu);
        }
        if ((all || obj instanceof ITimex3.Function) && this.funcMenu != null) {
            menu.appendToGroup("additions", (IContributionItem)this.funcMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeFunctionAction
    extends ChangeTimexFeatureAction<ITimex3.Function> {
        public ChangeFunctionAction(ITimex3.Function feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ITimex3 t) {
            return t.getFunction() == this.getFeature();
        }

        @Override
        protected ITimex3 create(ITimex3 old) {
            return new Timex3((Collection)old.getExpression(), old.getType(), old.getModifier(), (ITimex3.Function)this.getFeature(), (Collection)old.getQuantifier(), (Collection)old.getFrequency());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeModAction
    extends ChangeTimexFeatureAction<ITimex3.Mod> {
        public ChangeModAction(ITimex3.Mod feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ITimex3 e) {
            return e.getModifier() == this.getFeature();
        }

        @Override
        protected ITimex3 create(ITimex3 old) {
            return new Timex3((Collection)old.getExpression(), old.getType(), (ITimex3.Mod)this.getFeature(), old.getFunction(), (Collection)old.getQuantifier(), (Collection)old.getFrequency());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeTimexFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeTimexFeatureAction(F feature, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeTimexFeatureActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
            this.provider = provider;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeTimexFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof ITimex3) {
                return this.isChecked((ITimex3)element);
            }
            return false;
        }

        protected abstract boolean isChecked(ITimex3 var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            ITimex3 newEvent = this.create((ITimex3)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newEvent.calculatePosition(), (IData)newEvent, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract ITimex3 create(ITimex3 var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeTypeAction
    extends ChangeTimexFeatureAction<ITimex3.Type> {
        public ChangeTypeAction(ITimex3.Type feature, IStoryEditor editor, ISelectionProvider provider) {
            super(feature, editor, provider);
        }

        @Override
        protected boolean isChecked(ITimex3 t) {
            return t.getType() == this.getFeature();
        }

        @Override
        protected ITimex3 create(ITimex3 old) {
            return new Timex3((Collection)old.getExpression(), (ITimex3.Type)this.getFeature(), old.getModifier(), old.getFunction(), (Collection)old.getQuantifier(), (Collection)old.getFrequency());
        }
    }
}

