/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.util;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.util.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;
import org.w3c.dom.Document;

public class UIDebug {
    private static final char period = '.';
    private static final char spaceChar = ' ';
    private static final String colon = ": ";
    private static final String comma = ", ";
    private static final String emptyString = "";
    private static final String equals = "=";
    private static final String hash = "#";
    private static final String leftbracket = "[";
    private static final String needsImplementing = "needs to be implemented";
    private static final String nullIndicator = "null";
    private static final String pipe = "|";
    private static final String rightbracket = "]";
    private static final String spaceStr = " ";
    private static final String spaceCharToString = "\\s";
    private static final String underscore = "_";
    private static final String unknownMethod = "Unknown Method";
    private static boolean fDebug = true;

    public static void setDebug(boolean debug) {
        fDebug = debug;
    }

    public static boolean getDebug() {
        return fDebug;
    }

    public static void implement() {
        System.err.println(String.valueOf(UIDebug.getIdentifier()) + spaceStr + needsImplementing);
    }

    public static void implement(String note) {
        System.err.println(String.valueOf(UIDebug.getIdentifier()) + spaceStr + needsImplementing + colon + note);
    }

    public static void out() {
        System.out.println(UIDebug.getIdentifier());
    }

    public static void out(String message) {
        if (message == null) {
            System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + nullIndicator);
            return;
        }
        if (message.equals(emptyString)) {
            System.out.println(UIDebug.getIdentifier());
            return;
        }
        System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + message);
    }

    public static void outNoEOL(String message) {
        if (message == null) {
            System.out.print(String.valueOf(UIDebug.getIdentifier()) + comma + nullIndicator);
            return;
        }
        if (message.equals(emptyString)) {
            System.out.print(UIDebug.getIdentifier());
            return;
        }
        System.out.print(String.valueOf(UIDebug.getIdentifier()) + comma + message);
    }

    public static void out(Object o) {
        if (o == null) {
            System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + nullIndicator);
            return;
        }
        System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + o.toString());
    }

    public static void out(int skiplines, String message) {
        if (message == null) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.out.println(UIDebug.getIdentifier());
            return;
        }
        if (message.equals(emptyString)) {
            int i = 0;
            while (i < skiplines) {
                System.out.println();
                ++i;
            }
            System.out.println(UIDebug.getIdentifier());
            return;
        }
        int i = 0;
        while (i < skiplines) {
            System.out.println();
            ++i;
        }
        System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + message);
    }

    public static void err() {
        System.err.println(UIDebug.getIdentifier());
    }

    public static void err(String message) {
        if (message == null) {
            System.err.println(UIDebug.getIdentifier());
            return;
        }
        if (message.equals(emptyString)) {
            System.err.println(UIDebug.getIdentifier());
            return;
        }
        System.err.println(String.valueOf(UIDebug.getIdentifier()) + comma + message);
    }

    private static String getIdentifier() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length >= 5) {
            StackTraceElement lastCall = stack[4];
            return lastCall.toString();
        }
        return unknownMethod;
    }

    public static String toString(String str) {
        StringBuffer sb = new StringBuffer(str.length());
        int i = 0;
        while (i < str.length()) {
            sb.append(UIDebug.toString(str.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    public static String toString(IResourceDelta delta) {
        StringBuffer sb = new StringBuffer();
        UIDebug.toStringHelper(0, delta, sb);
        return sb.toString();
    }

    private static void toStringHelper(int inset, IResourceDelta delta, StringBuffer buffer) {
        IResourceDelta[] children;
        if (buffer == null) {
            return;
        }
        int i = 0;
        while (i < 2 * inset) {
            buffer.append(' ');
            ++i;
        }
        buffer.append(delta.toString());
        buffer.append("\n");
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            UIDebug.toStringHelper(inset + 1, child, buffer);
            ++n2;
        }
    }

    public static String toString(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == ' ') {
            return spaceCharToString;
        }
        return Character.toString(c);
    }

    public static String toString(IDesc[] descs) {
        StringBuffer sb = new StringBuffer();
        IDesc[] iDescArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            IDesc desc = iDescArray[n2];
            sb.append("\n\t");
            sb.append(desc.toString());
            ++n2;
        }
        return sb.toString();
    }

    public static String toString(Position p) {
        if (p == null) {
            return nullIndicator;
        }
        return "[offset=" + p.getOffset() + ",length=" + p.getLength() + rightbracket;
    }

    public static String toString(DocumentEvent e) {
        if (e == null) {
            return nullIndicator;
        }
        return "[offset=" + e.fOffset + ", length=" + e.fLength + ", textLength=" + e.fText.length() + ", text='" + e.fText + "']";
    }

    public static String toGraphicScale(int start, int end) {
        if (start > end) {
            return "start > end";
        }
        int count = start % 10;
        StringBuffer sb = new StringBuffer();
        sb.append("start=" + start + colon);
        int i = start;
        while (i < end) {
            sb.append(count);
            sb.append(underscore);
            count = (count + 1) % 10;
            ++i;
        }
        sb.append(count);
        sb.append(" end=" + end);
        return sb.toString();
    }

    public static String toGraphic(Position p) {
        if (p == null) {
            return nullIndicator;
        }
        return UIDebug.toGraphic(0, p);
    }

    public static String toGraphic(int start, Position p) {
        if (p == null) {
            return nullIndicator;
        }
        return UIDebug.toGraphic(start, p.getOffset() + p.getLength() + 2, p);
    }

    public static String toGraphic(int start, int end, Position p) {
        if (p == null) {
            return nullIndicator;
        }
        int count = start % 10;
        int right = p.getLength() + p.getOffset();
        StringBuffer sb = new StringBuffer();
        sb.append("start=" + start);
        sb.append(colon);
        int i = start;
        while (i <= end) {
            if (i == p.getOffset() & i == right) {
                sb.append(hash);
            } else if (i == p.getOffset()) {
                sb.append(leftbracket);
            } else if (i == right) {
                sb.append(rightbracket);
            } else if (i % 2 == 0) {
                sb.append(count);
            } else {
                sb.append('.');
            }
            if (i < end) {
                if (p.getOffset() <= i & i < right) {
                    sb.append(equals);
                } else {
                    sb.append(underscore);
                }
            }
            count = (count + 1) % 10;
            ++i;
        }
        sb.append(" end=" + end);
        sb.append(colon);
        sb.append(UIDebug.toString(p));
        return sb.toString();
    }

    public static String toGraphic(ITextStore s) {
        if (s == null) {
            return nullIndicator;
        }
        return UIDebug.toGraphic(0, s);
    }

    public static String toGraphic(int start, ITextStore s) {
        if (s == null) {
            return nullIndicator;
        }
        return UIDebug.toGraphic(start, s.getLength(), s);
    }

    public static String toGraphic(int start, int end, ITextStore s) {
        return UIDebug.toGraphic(start, end, s, ' ');
    }

    public static String toGraphic(int start, int end, ITextStore s, char nonSpaceWhitespaceChar) {
        start = Math.max(start, 0);
        start = Math.min(start, s.getLength());
        end = Math.min(end, s.getLength());
        StringBuffer sb = new StringBuffer();
        int i = start;
        sb.append("start=" + start + colon);
        sb.append(pipe);
        while (i < end) {
            char c = s.get(i);
            if (Character.isWhitespace(c) & c != ' ') {
                sb.append(nonSpaceWhitespaceChar);
            } else {
                sb.append(c);
            }
            sb.append(pipe);
            ++i;
        }
        sb.append(" end=");
        sb.append(end);
        sb.append(colon);
        sb.append("store.length()=");
        sb.append(s.getLength());
        return sb.toString();
    }

    public static String toGraphic(int start, int end, String s, char nonSpaceWhitespaceChar) {
        start = Math.max(start, 0);
        start = Math.min(start, s.length());
        end = Math.min(end, s.length());
        StringBuffer sb = new StringBuffer();
        int i = start;
        sb.append("start=" + start + colon);
        sb.append(pipe);
        while (i < end) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c) & c != ' ') {
                sb.append(nonSpaceWhitespaceChar);
            } else {
                sb.append(c);
            }
            sb.append(pipe);
            ++i;
        }
        sb.append(" end=");
        sb.append(end);
        sb.append(colon);
        sb.append("length()=");
        sb.append(s.length());
        return sb.toString();
    }

    public static void listPosition(String prefix, Position p) {
        if (p == null) {
            System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + prefix + " : null");
        } else {
            System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + prefix + " : " + UIDebug.toString(p) + " toString():(" + p + ")");
        }
    }

    public static void listPositions(String prefix, Position[] ps) {
        if (ps.length == 0) {
            System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + prefix + " : (none)");
        }
        Position[] positionArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            Position p = positionArray[n2];
            if (p == null) {
                System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + prefix + spaceStr + colon + nullIndicator);
            } else {
                System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + prefix + spaceStr + colon + UIDebug.toString(p) + " toString():(" + p + ")");
            }
            ++n2;
        }
    }

    public static void listAllPositions(IDocument doc) {
        String[] cats;
        String[] stringArray = cats = doc.getPositionCategories();
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            if (cat.startsWith("edu.mit")) {
                Position[] ps;
                try {
                    ps = doc.getPositions(cat);
                }
                catch (BadPositionCategoryException e) {
                    throw new RuntimeException(e);
                }
                if (ps.length == 0) {
                    System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + cat + " : (none)");
                }
                Position[] positionArray = ps;
                int n3 = ps.length;
                int n4 = 0;
                while (n4 < n3) {
                    Position p = positionArray[n4];
                    if (p == null) {
                        System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + cat + spaceStr + colon + nullIndicator);
                    } else {
                        System.out.println(String.valueOf(UIDebug.getIdentifier()) + comma + cat + spaceStr + colon + UIDebug.toString(p) + " toString():(" + p + ")");
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static void printDocument(Document xml) {
        InputStream s = XMLUtils.toStream((Document)xml);
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while ((c = s.read()) != -1) {
                buffer.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UIDebug.out(buffer.toString());
    }
}

