/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions;

import edu.mit.story.core.util.IUtilityClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectionUtils
implements IUtilityClass {
    private SelectionUtils() {
    }

    public static <T> T cast(Object obj, Class<T> cls) {
        if (obj == null) {
            return null;
        }
        return cls.isAssignableFrom(obj.getClass()) ? (T)cls.cast(obj) : null;
    }

    public static IStructuredSelection castAsStructuredSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public static ITextSelection castAsTextSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return selection instanceof ITextSelection ? (ITextSelection)selection : null;
    }

    public static <T> T extractFirst(ISelection selection, Class<T> cls) {
        if (selection == null || cls == null) {
            return null;
        }
        IStructuredSelection sel = SelectionUtils.castAsStructuredSelection(selection);
        if (sel == null) {
            return null;
        }
        for (Object element : sel) {
            if (!cls.isAssignableFrom(element.getClass())) continue;
            return cls.cast(element);
        }
        return null;
    }

    public static <T> T extractSingle(ISelection selection, Class<T> cls) {
        if (selection == null || cls == null) {
            return null;
        }
        IStructuredSelection sel = SelectionUtils.castAsStructuredSelection(selection);
        if (sel == null) {
            return null;
        }
        T result = null;
        for (Object element : sel) {
            if (!cls.isAssignableFrom(element.getClass())) continue;
            if (result != null) {
                return null;
            }
            result = cls.cast(element);
        }
        return result;
    }

    public static <T> List<T> extractAll(ISelection selection, Class<T> cls) {
        if (selection == null || cls == null) {
            return null;
        }
        IStructuredSelection sel = SelectionUtils.castAsStructuredSelection(selection);
        if (sel == null) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Object element : sel) {
            if (!cls.isAssignableFrom(element.getClass())) continue;
            result.add(cls.cast(element));
        }
        return result;
    }

    public static <T> T extractFirst(Object[] objects, Class<T> cls) {
        if (objects == null || cls == null) {
            return null;
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (cls.isAssignableFrom(element.getClass())) {
                return cls.cast(element);
            }
            ++n2;
        }
        return null;
    }

    public static <T> T extractSingle(Object[] objects, Class<T> cls) {
        if (objects == null || cls == null) {
            return null;
        }
        T result = null;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (cls.isAssignableFrom(element.getClass())) {
                if (result != null) {
                    return null;
                }
                result = cls.cast(element);
            }
            ++n2;
        }
        return result;
    }

    public static <T> List<T> extractAll(Object[] objects, Class<T> cls) {
        if (objects == null || cls == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (cls.isAssignableFrom(element.getClass())) {
                result.add(cls.cast(element));
            }
            ++n2;
        }
        return result;
    }

    public static String toString(ISelection selection) {
        ITextSelection tSel;
        if (selection == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(selection.getClass().getCanonicalName());
        sb.append(":\n");
        IStructuredSelection sSel = SelectionUtils.castAsStructuredSelection(selection);
        if (sSel != null) {
            sb.append("\tStructured:\n");
            Object[] objectArray = sSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                sb.append("\t\t");
                sb.append(o.toString());
                sb.append("\n");
                ++n2;
            }
        }
        if ((tSel = SelectionUtils.castAsTextSelection(selection)) != null) {
            sb.append("\tText:\n");
            sb.append("\t\ttext='" + tSel.getText() + "'\n");
            sb.append("\t\toffset=" + tSel.getOffset() + "\n");
            sb.append("\t\tlength=" + tSel.getLength() + "\n");
        }
        return sb.toString();
    }
}

