/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.helpers;

import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.ui.content.SentenceContentProvider;
import edu.mit.parsing.ui.label.SentenceLabelProvider;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.editor.StoryEditorRedoAction;
import edu.mit.story.ui.actions.editor.StoryEditorUndoAction;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.items.CommandHooks;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.services.IServiceLocator;

public class SentenceDetailsPage
extends HelperPage
implements IDetailsPage,
IModelListener,
IAdaptable {
    public static final String ID = "edu.mit.parsing.ui.helpers.SentenceDetailsPage";
    private TreeViewer treeViewer;
    private IAction undoAction;
    private IAction redoAction;
    private IAction expandAction;
    private IAction collapseAction;

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 772);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setContentProvider((IContentProvider)new SentenceContentProvider(this.getStoryEditor()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SentenceLabelProvider(this.getStoryEditor()));
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.setControl((Control)this.treeViewer.getTree());
        CommandContributionItem deleteItem = CommandHooks.createDelete((IServiceLocator)this.getSite().getWorkbenchWindow());
        CommandContributionItem editItem = CommandHooks.createEdit((IServiceLocator)this.getSite().getWorkbenchWindow());
        this.undoAction = new StoryEditorUndoAction(this.getStoryEditor());
        this.redoAction = new StoryEditorRedoAction(this.getStoryEditor());
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        manager.appendToGroup("group.edit", (IContributionItem)editItem);
        manager.appendToGroup("group.edit", (IContributionItem)deleteItem);
        Menu menu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.getSite().registerContextMenu("edu.mit.parsing.ui.helpers.SentenceDetailsPage.popupMenu", manager, (ISelectionProvider)this.treeViewer);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    public void modelChanged(StoryChangeEvent e) {
        if (this.treeViewer == null) {
            return;
        }
        if (this.treeViewer.getControl().isDisposed()) {
            return;
        }
        if (!e.affects(SentenceRep.getInstance())) {
            return;
        }
        this.treeViewer.refresh();
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener((IModelListener)this);
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

