/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.core.util.LogUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils
implements IUtilityClass {
    private static String lineDelimiter = null;
    private static String fileSeparator = null;
    public static final String NULL = "null";
    public static final String right_bracket = "[";
    public static final String left_bracket = "]";
    public static final String comma_space = ", ";
    public static final char period = '.';
    public static final char hyphen = '-';

    private StringUtils() {
    }

    public static boolean isNullorZero(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }

    public static boolean containsWhitespace(CharSequence cs) {
        int i = 0;
        while (i < cs.length()) {
            if (Character.isWhitespace(cs.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static StringBuffer toStringBuffer(IFile file) {
        StringBuffer result = new StringBuffer();
        if (!file.exists()) {
            return result;
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(file.getContents());
            StringUtils.loadStreamIntoBuffer(result, stream);
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            LogUtils.logError((Plugin)StoryPlugin.getDefault(), e);
        }
        return result;
    }

    public static String getAddress(Object o) {
        if (o == null) {
            return NULL;
        }
        return Integer.toHexString(o.hashCode());
    }

    public static String getClassName(Class<?> c) {
        if (c == null) {
            return NULL;
        }
        return c.getCanonicalName().substring(c.getCanonicalName().lastIndexOf(46) + 1);
    }

    public static String toString(Object[] os) {
        if (os == null) {
            return NULL;
        }
        if (os.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(right_bracket);
        int i = 0;
        while (i < os.length) {
            sb.append(os[i].toString());
            if (i + 1 < os.length) {
                sb.append(comma_space);
            }
            ++i;
        }
        sb.append(left_bracket);
        return sb.toString();
    }

    public static String toString(InputStream stream) {
        StringBuffer sb = new StringBuffer();
        StringUtils.loadStreamIntoBuffer(sb, stream);
        return sb.toString();
    }

    public static void loadStreamIntoBuffer(Appendable buffer, InputStream stream) {
        if (buffer == null || stream == null) {
            return;
        }
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = stream.read(buf)) != -1) {
                int i = 0;
                while (i < count) {
                    buffer.append((char)buf[i]);
                    ++i;
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String getLineDelimiter() {
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        lineDelimiter = System.getProperty("line.delimiter");
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return "\n";
        }
        if (osName.contains("Windows")) {
            lineDelimiter = "\r\n";
        } else if (osName.contains("Mac")) {
            lineDelimiter = "\r";
        }
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        lineDelimiter = "\n";
        return lineDelimiter;
    }

    public static String getFileSeparator() {
        if (fileSeparator != null) {
            return fileSeparator;
        }
        fileSeparator = System.getProperty("file.separator");
        if (fileSeparator != null) {
            return fileSeparator;
        }
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return "\n";
        }
        fileSeparator = osName.contains("Windows") ? "\\" : "/";
        return fileSeparator;
    }

    public static boolean isLocalhostAddr(String addr) {
        return addr.equals("localhost") | addr.equals("127.0.0.1");
    }

    public static String toList(Collection<? extends String> strings) {
        StringBuffer sb = new StringBuffer();
        Iterator<? extends String> i = strings.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(comma_space);
        }
        return sb.toString();
    }

    public static String fillString(String str, int fill) {
        StringBuilder sb = new StringBuilder();
        sb.append(str);
        int i = sb.length();
        while (i < fill) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static String shortenText(String text, int maxLength) {
        if (text.length() < maxLength) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int mid = maxLength / 2;
        result.append(text.substring(0, mid));
        result.append("...");
        result.append(text.substring(text.length() - mid));
        return result.toString();
    }

    public static String indent(String prefix, String content) {
        StringBuffer sb = new StringBuffer(content.length());
        int start = 0;
        int end = 0;
        while (end < content.length()) {
            end = StringUtils.findNextEndOfLine(start, content);
            if (end == -1) {
                end = content.length();
            }
            sb.append(prefix);
            sb.append(content.substring(start, end));
            start = end;
        }
        return sb.toString();
    }

    public static int findFirstEndOfLine(String str) {
        return StringUtils.findNextEndOfLine(0, str);
    }

    /*
     * Unable to fully structure code
     */
    public static int findNextEndOfLine(int idx, String str) {
        if (str.length() != 0) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            if (++idx != str.length()) continue;
            return -1;
lbl5:
            // 2 sources

            ** while (str.charAt((int)idx) != '\n' && str.charAt((int)idx) != '\r')
        }
lbl6:
        // 1 sources

        foundCR = str.charAt(idx) == '\r';
        if (foundCR && ++idx < str.length() - 1 && str.charAt(idx) == '\n') {
            ++idx;
        }
        return idx;
    }
}

