/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model.change;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.change.AbstractModelChange;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IRep;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CalculateDescsChange
extends AbstractModelChange {
    private final IRep rep;

    public CalculateDescsChange(IRep rep) {
        super("Calculate Descriptions");
        if (rep == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
    }

    protected StoryChangeEvent doApply(Object source, IMutableStoryModel model) {
        IDescFactory factory = model.getFactory(this.rep);
        if (factory == null) {
            return null;
        }
        IDescSet newDs = factory.calculateDescs(model.getData(), model);
        IDescSet oldDs = model.getData().getDescriptions(this.rep);
        HashSet<IDesc> keepDs = new HashSet<IDesc>();
        Iterator i = newDs.iterator();
        while (i.hasNext()) {
            IDesc matchD = this.findMatch((IDesc)i.next(), oldDs);
            if (matchD == null) continue;
            keepDs.add(matchD);
            i.remove();
        }
        Predicate notInKeepDs = Predicates.not((Predicate)Predicates.in(keepDs));
        RemoveDescriptionsChange remove = new RemoveDescriptionsChange(Collections2.filter((Collection)oldDs, (Predicate)notInKeepDs));
        AddDescriptionsChange add = new AddDescriptionsChange(newDs);
        CompositeModelChange composite = new CompositeModelChange(remove, add);
        return composite.apply(source, model);
    }

    protected IDesc findMatch(IDesc newD, IDescSet oldDs) {
        for (IDesc oldD : oldDs.matchSet(newD)) {
            if (!newD.getDataString().equals(oldD.getDataString())) continue;
            return oldD;
        }
        return null;
    }
}

