/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.mappers;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.mappers.IValueMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockMapper
implements IValueMapper<String> {
    public static final IValueMapper<String> COLON = new BlockMapper(":");
    public static final IValueMapper<String> COMMA = new BlockMapper(",");
    public static final IValueMapper<String> PIPE = new BlockMapper("|");
    public static final IValueMapper<String> SEMICOLON = new BlockMapper(";");
    public static final IValueMapper<String> SLASH_FORWARD = new BlockMapper("/");
    public static final IValueMapper<String> SPACE = new BlockMapper(" ");
    public static final IValueMapper<String> TILDE = new BlockMapper("~");
    public static final IValueMapper<String> DASH = new BlockMapper("-");
    private final String sepString;
    private final Pattern sepPattern;
    private final String errorMessage;

    public BlockMapper(String sepString) {
        this(sepString, Pattern.compile(Pattern.quote(sepString)));
    }

    public BlockMapper(String sepString, Pattern sepPattern) {
        if (sepString == null || sepPattern == null) {
            throw new NullPointerException();
        }
        this.sepString = sepString;
        this.sepPattern = sepPattern;
        this.errorMessage = NLS.bind((String)StoryMessages.MSG_IllegalBlockMapperString, (Object)sepString);
    }

    @Override
    public List<String> reconstitute(String value) {
        String trimmed = value.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        String[] blocks = this.sepPattern.split(trimmed, -1);
        return blocks.length == 0 ? Collections.emptyList() : Arrays.asList(blocks);
    }

    @Override
    public String serialize(Collection<? extends String> objects) {
        StringBuffer sb = new StringBuffer();
        if (objects != null) {
            Iterator<? extends String> i = objects.iterator();
            while (i.hasNext()) {
                String str = i.next();
                if (str.indexOf(this.sepString) != -1) {
                    throw new IllegalArgumentException(this.errorMessage);
                }
                sb.append(str);
                if (!i.hasNext()) continue;
                sb.append(this.sepString);
            }
        }
        return sb.toString();
    }
}

