/* Filename: IReferentProperty.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 23, 2009
 */
package edu.mit.discourse.core.rep.refprops;

import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.util.IHasDisplayText;

/**
 * A property of a discourse referent. For example in the sentence
 * "The man was greedy", 'the old man' is the referent, where as 'old' and
 * 'greedy' are properties.
 * 
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.core 1.0.0
 */
public interface IReferentProperty extends IStructuredData, IHasDisplayText {
	
	public PropertyType getType();

	/**
	 * Returns the referent to which this property applies. Will never return
	 * <code>null</code>. The returned description will be of the
	 * {@link ReferentRep} type.
	 * 
	 * @return the referent to which this property applies
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public IDesc getReferringExpression();

	/**
	 * Returns the set of segments for this referent property. Each segment will
	 * be runs of token descriptions. Will never return <code>null</code> or the
	 * empty set.
	 * 
	 * @return the non-<code>null</code>, non-empty set of segments that
	 *         comprise this property
	 * @see TokenRep
	 * @since edu.mit.discourse.core 1.0.0
	 */
	public ISegmentSet getExtent();

}
