/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.ui.controllers;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.sentence.model.ISentenceModel;
import edu.mit.parsing.core.rep.sentence.model.SentenceModel;
import edu.mit.parsing.ui.controllers.ISentenceController;
import edu.mit.parsing.ui.controllers.SegmentController;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.ChangeUtils;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.editor.IStoryEditor;

public class SentenceController
extends SegmentController
implements ISentenceController {
    public SentenceController(String annoID, IStoryEditor editor) {
        this((ISentenceModel)new SentenceModel((IStoryModel)editor.getStoryModel()), annoID, editor);
    }

    public SentenceController(ISentenceModel model, String annoID, IStoryEditor editor) {
        super((ISegmentModel)model, annoID, editor);
    }

    public ISentenceModel getModel() {
        return (ISentenceModel)super.getModel();
    }

    public void load(IDesc sentence) {
        this.getModel().load(sentence);
    }

    public void commit() {
        ISentenceModel model = this.getModel();
        if (model.getMessageType() == 3) {
            return;
        }
        Timing timing = new Timing(model.getStart(), "user");
        ISentence data = model.toSentence();
        IHasPosition p = data.calculatePosition();
        ChangeUtils.edit((Object)this, (IMutableStoryModel)this.getStoryEditor().getStoryModel(), (IRep)SentenceRep.getInstance(), (IHasPosition)p, (IData)data, (ITiming)timing, (IDesc)model.getLoaded());
        this.clear();
    }
}

