/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.controllers;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.controllers.IAnnotationController;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AnnotationModelChild;
import edu.mit.story.ui.model.IAnnotationModelChild;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationController
implements IAnnotationController {
    protected final String annoID;
    protected final IAnnotationModelChild model;

    public AnnotationController(String annoID, IStoryEditor editor) {
        this(annoID, AnnotationModelChild.createChildAnnotationModel(editor));
    }

    public AnnotationController(String annoID, IAnnotationModelChild model) {
        if (annoID.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (model == null) {
            throw new NullPointerException();
        }
        this.annoID = annoID;
        this.model = model;
    }

    @Override
    public IAnnotationModelChild getAnnotationModel() {
        return this.model;
    }

    @Override
    public String getAnnotationID() {
        return this.annoID;
    }

    @Override
    public void setAnnotating(boolean value) {
        this.model.setAnnotating(value);
    }

    @Override
    public void setPositions(Collection<? extends IHasPosition> ps) {
        Annotation a;
        if (ps == null) {
            ps = Collections.emptySet();
        }
        HashSet<Position> addThese = new HashSet<Position>();
        HashSet<Annotation> removeThese = new HashSet<Annotation>();
        for (IHasPosition iHasPosition : ps) {
            addThese.add(PositionUtils.toDocumentPosition((IHasPosition)iHasPosition));
        }
        Iterator i = this.model.getAnnotationIterator();
        while (i.hasNext()) {
            a = (Annotation)i.next();
            Position position = this.model.getPosition(a);
            if (addThese.remove(position)) continue;
            removeThese.add(a);
        }
        HashMap<Annotation, Position> toAdd = new HashMap<Annotation, Position>(addThese.size());
        for (Position pos : addThese) {
            a = new Annotation(this.annoID, false, StoryUIMessages.ANNOTATION_PositionSpecification_text);
            toAdd.put(a, pos);
        }
        if (removeThese.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        this.model.replaceAnnotations(removeThese.toArray(new Annotation[removeThese.size()]), toAdd);
    }

    @Override
    public void clear() {
        this.setPositions(null);
    }

    public void dispose() {
        this.model.dispose();
    }
}

