/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.build;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.build.IBuildRule;
import edu.mit.story.core.build.IBuildRuleManager;
import edu.mit.story.core.property.CorpusConfiguration;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.property.ICorpusConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.IRepSupporter;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.util.ImmutableIterator;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.build.IContextBuildRule;
import edu.mit.story.ui.build.IContextBuildRuleManager;
import edu.mit.story.ui.build.StoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryNature
implements IProjectNature,
IRepSupporter {
    public static final String ID = "edu.mit.story.ui.nature";
    private IProject project;
    private IFile configFile;
    private IResourceChangeListener corpusFileListener;
    private ICorpusConfiguration corpusConfig;
    private List<IBuildRule> buildRules;
    private List<IContextBuildRule> contextBuildRules;

    public void configure() throws CoreException {
        StoryBuilder.addStoryBuilder(this.getProject());
        this.getProject().getWorkspace().addResourceChangeListener(this.getCorpusFileListener());
    }

    public void deconfigure() throws CoreException {
        StoryBuilder.removeStoryBuilder(this.getProject());
        this.getProject().getWorkspace().removeResourceChangeListener(this.getCorpusFileListener());
    }

    public IProject getProject() {
        return this.project;
    }

    protected IResourceChangeListener getCorpusFileListener() {
        if (this.corpusFileListener == null) {
            this.corpusFileListener = new IResourceChangeListener(){
                private IFile corpusFile;

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) {
                        return;
                    }
                    IResourceDelta member = delta.findMember(this.getCorpusFile().getFullPath());
                    if (member == null) {
                        return;
                    }
                    ICorpusConfiguration config = StoryNature.this.readConfiguration();
                    if (config != null && !config.equals((Object)StoryNature.this.corpusConfig)) {
                        StoryNature.this.corpusConfig = config;
                    }
                }

                protected IFile getCorpusFile() {
                    if (this.corpusFile == null) {
                        this.corpusFile = StoryNature.this.getProject().getFile(".corpus");
                    }
                    return this.corpusFile;
                }
            };
        }
        return this.corpusFileListener;
    }

    public void setProject(IProject newProject) {
        this.project = newProject;
        this.configFile = this.project == null ? null : this.project.getFile(".corpus");
    }

    public synchronized ICorpusConfiguration getProjectConfiguration() {
        if (this.corpusConfig == null) {
            ICorpusConfiguration config = this.readConfiguration();
            if (config == null) {
                config = new CorpusConfiguration(this.getProject());
            }
            this.corpusConfig = config;
        }
        return this.corpusConfig;
    }

    protected ICorpusConfiguration readConfiguration() {
        Status status;
        if (this.configFile == null) {
            return null;
        }
        if (!this.configFile.exists()) {
            return null;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.configFile.findMarkers("edu.mit.story.core.marker.story", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
        }
        try {
            Document xml = XMLUtils.getBuilder().parse(new InputSource(this.configFile.getContents()));
            return CorpusConfiguration.fromXML((IProject)this.getProject(), (Document)xml);
        }
        catch (Exception e) {
            status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
            try {
                IMarker marker = this.configFile.createMarker("edu.mit.story.core.marker.problem");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)StoryUIMessages.MSG_CorpusFileMisformatted);
            }
            catch (Exception e2) {
                status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e2.getLocalizedMessage(), (Throwable)e2);
                StoryUIPlugin.getDefault().getLog().log((IStatus)status);
            }
            return null;
        }
    }

    public int repSize() {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return config.repSize();
    }

    public Iterator<IRep> repIterator() {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return new ImmutableIterator(config.repIterator());
    }

    public boolean supports(IRep rep) {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return config.supports(rep);
    }

    public boolean supportsAll(Collection<? extends IRep> reps) {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return config.supportsAll(reps);
    }

    public IRepSet getSupported() {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return config.getSupported();
    }

    public IRepSet getRequired() {
        ICorpusConfiguration config = this.getProjectConfiguration();
        RepSet result = new RepSet();
        for (IRep rep : config.getSupported()) {
            if (!config.isRequired(rep)) continue;
            result.add((Object)rep);
        }
        return result;
    }

    public List<IBuildRule> getBuildRules() {
        if (this.buildRules == null) {
            LinkedList rules = new LinkedList();
            IBuildRuleManager manager = StoryPlugin.getDefault().getBuildRuleManager();
            for (IRep rep : this.getSupported()) {
                rules.addAll(manager.getBuildRules(rep));
            }
            this.buildRules = Collections.unmodifiableList(new ArrayList(rules));
        }
        return this.buildRules;
    }

    public List<IContextBuildRule> getContextBuildRules() {
        if (this.contextBuildRules == null) {
            LinkedList rules = new LinkedList();
            IContextBuildRuleManager manager = StoryUIPlugin.getDefault().getBuildRuleManager();
            for (IRep rep : this.getSupported()) {
                rules.addAll(manager.getBuildRules(rep));
            }
            this.contextBuildRules = Collections.unmodifiableList(new ArrayList(rules));
        }
        return this.contextBuildRules;
    }

    public IConfiguration getFactoryConfiguration(IRep rep) {
        ICorpusConfiguration config = this.getProjectConfiguration();
        return config.getFactoryConfiguration(rep);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean addStoryNature(IProject project, IProgressMonitor monitor) {
        message = "Adding Story Nature";
        monitor.beginTask(message, 2000);
        try {
            description = null;
            try {
                description = project.getDescription();
            }
            catch (CoreException e) {
                status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
                StoryUIPlugin.getDefault().getLog().log((IStatus)status);
lbl11:
                // 3 sources

                return false;
            }
            if (description == null) ** GOTO lbl11
            natures = description.getNatureIds();
            newNatures = new String[natures.length + 1];
            newNatures[0] = "edu.mit.story.ui.nature";
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            monitor.worked(1000);
            description.setNatureIds(newNatures);
            natures = description.getNatureIds();
            try {
                project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                return true;
            }
            catch (CoreException e) {
                status = new Status(4, StoryUIPlugin.getDefault().getID(), 0, e.getLocalizedMessage(), (Throwable)e);
                StoryUIPlugin.getDefault().getLog().log((IStatus)status);
                ** continue;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static StoryNature getStoryNature(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IProjectNature nature = project.getNature(ID);
            return nature instanceof StoryNature ? (StoryNature)nature : null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static boolean hasStoryNature(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature(ID);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

