/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.editor;

import edu.mit.story.ui.actions.editor.StoryEditorOperationHistoryAction;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AsyncStoryModel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.PlatformUI;

public final class StoryEditorUndoAction
extends StoryEditorOperationHistoryAction {
    public StoryEditorUndoAction(IStoryEditor editor) {
        super(editor);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
        this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
    }

    protected IStatus runCommand() throws ExecutionException {
        IUndoableOperation op = this.getOperation();
        boolean undoViewer = false;
        if (op instanceof AsyncStoryModel.ModelChangeOperation) {
            undoViewer = ((AsyncStoryModel.ModelChangeOperation)op).didViewerChange();
        }
        IStatus result = this.getHistory().undo(this.getModelUndoContext(), null, null);
        if (undoViewer && this.getHistory().canUndo(this.getViewerUndoContext())) {
            this.getStoryModel().setIgnoreChanges(true);
            this.getHistory().undo(this.getViewerUndoContext(), null, null);
            this.getStoryModel().setIgnoreChanges(false);
        }
        return result;
    }

    protected IUndoableOperation getOperation() {
        return this.getHistory().getUndoOperation(this.getModelUndoContext());
    }

    protected boolean shouldBeEnabled() {
        return this.getHistory().canUndo(this.getModelUndoContext());
    }

    protected String getCommandString() {
        return "&Undo {0}";
    }

    protected String getTooltipString() {
        return "Undo {0}";
    }

    protected String getSimpleCommandString() {
        return "&Undo";
    }

    protected String getSimpleTooltipString() {
        return "Undo";
    }
}

