/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexWord
implements IIndexWord {
    private final IIndexWordID fID;
    private final int fTagSenseCnt;
    private final List<IWordID> fWordIDs;

    public IndexWord(String lemma, POS pos, int tagSenseCnt, IWordID[] words) {
        this(new IndexWordID(lemma, pos), tagSenseCnt, words);
    }

    public IndexWord(IIndexWordID id, int tagSenseCnt, IWordID[] words) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (words.length == 0) {
            throw new IllegalArgumentException();
        }
        if (tagSenseCnt < 0) {
            throw new IllegalArgumentException();
        }
        this.fID = id;
        this.fTagSenseCnt = tagSenseCnt;
        this.fWordIDs = Collections.unmodifiableList(Arrays.asList(words));
    }

    @Override
    public String getLemma() {
        return this.fID.getLemma();
    }

    @Override
    public List<IWordID> getWordIDs() {
        return this.fWordIDs;
    }

    @Override
    public int getTagSenseCount() {
        return this.fTagSenseCnt;
    }

    @Override
    public IIndexWordID getID() {
        return this.fID;
    }

    @Override
    public POS getPOS() {
        return this.fID.getPOS();
    }

    public String toString() {
        String result = "[" + this.fID.getLemma() + " (" + (Object)((Object)this.fID.getPOS()) + ") ";
        for (IWordID id : this.fWordIDs) {
            result = result + id.toString() + ", ";
        }
        result = result.substring(0, result.length() - 2) + "]";
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fID.hashCode();
        result = 31 * result + this.fTagSenseCnt;
        result = 31 * result + ((Object)this.fWordIDs).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IIndexWord)) {
            return false;
        }
        IndexWord other = (IndexWord)obj;
        if (!this.fID.equals(other.getID())) {
            return false;
        }
        if (this.fTagSenseCnt != other.getTagSenseCount()) {
            return false;
        }
        return ((Object)this.fWordIDs).equals(other.getWordIDs());
    }
}

