/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.util;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.sentence.SentenceRep;
import edu.mit.parsing.core.rep.stem.IStem;
import edu.mit.parsing.core.rep.stem.StemRep;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.util.BaseWordInfo;
import edu.mit.parsing.core.util.IWordInfo;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;

public class WordInfo
extends BaseWordInfo
implements IWordInfo {
    private final IDesc desc;
    private final IDesc tag;
    private final IDesc stem;
    private final IDesc sent;

    public WordInfo(IDesc desc, IDesc tag, IDesc stem, IDesc sent) {
        super((IBaseToken)desc.getData(), tag == null ? null : (IPosTag)tag.getData(), stem == null ? null : (IStem)stem.getData(), sent == null ? null : (ISentence)sent.getData());
        this.desc = desc;
        this.tag = tag;
        this.stem = stem;
        this.sent = sent;
    }

    public IDesc getDesc() {
        return this.desc;
    }

    public IDesc getPOSDesc() {
        return this.tag;
    }

    public IDesc getSentenceDesc() {
        return this.sent;
    }

    public IDesc getStemDesc() {
        return this.stem;
    }

    public IPosTag getPosTag() {
        return (IPosTag)super.getPosTag();
    }

    public IStem getStem() {
        return (IStem)super.getStem();
    }

    public static WordInfo extract(IDesc word, IStoryModel model) {
        IDescSet ds;
        IDesc stem = null;
        IDesc tag = null;
        IDesc sent = null;
        if (model.getData().supports(POSRep.getInstance())) {
            ds = model.getData().getDescriptions(POSRep.getInstance());
            ds = ds.matchSet((IHasPosition)word);
            for (IDesc tagDesc : ds) {
                IPosTag t = (IPosTag)tagDesc.getData();
                if (t.getWord() != word) continue;
                if (tag != null) {
                    tag = null;
                    break;
                }
                tag = tagDesc;
            }
        }
        if (model.getData().supports(StemRep.getInstance())) {
            ds = model.getData().getDescriptions(StemRep.getInstance());
            ds = ds.matchSet((IHasPosition)word);
            for (IDesc stemDesc : ds) {
                IStem s = (IStem)stemDesc.getData();
                if (s.getWord() != word) continue;
                if (stem != null) {
                    stem = null;
                    break;
                }
                stem = stemDesc;
            }
        }
        if (model.getData().supports(SentenceRep.getInstance())) {
            ds = model.getData().getDescriptions(SentenceRep.getInstance());
            if ((ds = ds.closedSet((IHasPosition)word)).size() == 1) {
                sent = (IDesc)ds.first();
            }
        }
        return new WordInfo(word, tag, stem, sent);
    }
}

