/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.validation;

import edu.mit.story.core.IStoryConstants;
import edu.mit.story.core.validation.BaseValidator;
import edu.mit.story.core.validation.IListValidator;
import edu.mit.story.core.validation.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListValidator<V>
extends BaseValidator<V>
implements IListValidator<V> {
    private final boolean isRestricted;
    private final List<V> values;

    public ListValidator(List<V> values, boolean restricted) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.values = Collections.unmodifiableList(new ArrayList<V>(values));
        this.isRestricted = restricted;
    }

    @Override
    public List<V> getValueList() {
        return this.values;
    }

    @Override
    public boolean isRestrictedToList() {
        return this.isRestricted;
    }

    @Override
    public IMessageProvider validate(V value) {
        if (value == null) {
            return IStoryConstants.noNullValues;
        }
        if (this.values.contains(value)) {
            return null;
        }
        return this.isRestricted ? new Message("The value is invalid: " + String.valueOf(value), 3) : this.doValidate(value);
    }

    protected IMessageProvider doValidate(V value) {
        return null;
    }
}

