/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc.factory;

import edu.mit.story.core.StoryMessages;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.factory.FactoryDescriptor;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.desc.factory.IFactoryDescriptor;
import edu.mit.story.core.desc.factory.IFactoryManager;
import edu.mit.story.core.desc.factory.NullDescFactory;
import edu.mit.story.core.manager.AssistantManager;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryManager
extends AssistantManager<IDescFactory, IFactoryDescriptor>
implements IFactoryManager {
    private Map<IRep, IFactoryDescriptor> nullMap = new TreeMap<IRep, IFactoryDescriptor>();

    @Override
    protected boolean doInit() {
        IConfigurationElement element;
        SortedMap<IRep, IConfigurationElement> repMap = FactoryManager.getRepElements();
        for (Map.Entry entry : repMap.entrySet()) {
            element = this.extractDefault((IConfigurationElement)entry.getValue());
            if (element == null) continue;
            this.registerDefault((IRep)entry.getKey(), new FactoryDescriptor((IRep)entry.getKey(), element, false));
        }
        for (Map.Entry entry : repMap.entrySet()) {
            element = this.extractNull((IConfigurationElement)entry.getValue());
            if (element == null) {
                this.registerNull((IRep)entry.getKey(), new NullFactoryDescriptor((IRep)entry.getKey()));
                continue;
            }
            this.registerNull((IRep)entry.getKey(), new FactoryDescriptor((IRep)entry.getKey(), element, true));
        }
        for (Map.Entry<Object, Object> entry : FactoryManager.getAssistantFactories().entrySet()) {
            for (IConfigurationElement e : (List)entry.getValue()) {
                this.registerDescriptor((IRep)entry.getKey(), new FactoryDescriptor(e));
            }
        }
        return true;
    }

    protected IConfigurationElement extractDefault(IConfigurationElement e) {
        IConfigurationElement[] es = e.getChildren("defaultFactory");
        return es.length > 0 ? es[0] : null;
    }

    protected IConfigurationElement extractNull(IConfigurationElement e) {
        IConfigurationElement[] es = e.getChildren("nullFactory");
        return es.length > 0 ? es[0] : null;
    }

    protected void registerNull(IRep rep, IFactoryDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.nullMap.put(rep, desc);
        this.registerDescriptor(rep, desc);
    }

    @Override
    protected void makeUnmodifiable() {
        super.makeUnmodifiable();
        this.nullMap = Collections.unmodifiableMap(this.nullMap);
    }

    @Override
    public IFactoryDescriptor getNull(IRep rep) {
        return this.nullMap.get(rep);
    }

    public static SortedMap<IRep, List<IConfigurationElement>> getAssistantFactories() {
        TreeMap<IRep, List<IConfigurationElement>> result = new TreeMap<IRep, List<IConfigurationElement>>();
        for (IConfigurationElement element : FactoryManager.getElements("edu.mit.story.core.factories", "factory")) {
            String repID = element.getAttribute("repID");
            IRep rep = StoryPlugin.getDefault().getRepManager().getRep(repID);
            if (rep == null) break;
            ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)result.get(rep);
            if (list == null) {
                list = new ArrayList<IConfigurationElement>();
                result.put(rep, list);
            }
            list.add(element);
        }
        return result;
    }

    public static String makeNullFactoryID(IRep rep) {
        return String.valueOf(rep.getID()) + ".factory.null";
    }

    public static String makeDefaultFactoryID(IRep rep) {
        return String.valueOf(rep.getID()) + ".factory.default";
    }

    public static String makeNullFactoryName(IRep rep) {
        return NLS.bind((String)StoryMessages.FACTORY_Null_name, (Object)rep.getName());
    }

    public static String makeDefaultFactoryName(IRep rep) {
        return NLS.bind((String)StoryMessages.FACTORY_Default_name, (Object)rep.getName());
    }

    public static String makeNullFactoryDesc(IRep rep) {
        return NLS.bind((String)StoryMessages.FACTORY_Null_desc, (Object)rep.getName());
    }

    public static String makeDefaultFactoryDesc(IRep rep) {
        return NLS.bind((String)StoryMessages.FACTORY_Default_desc, (Object)rep.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullFactoryDescriptor
    implements IFactoryDescriptor {
        private final IRep rep;
        private String id;
        private String name;
        private String desc;

        public NullFactoryDescriptor(IRep rep) {
            if (rep == null) {
                throw new NullPointerException();
            }
            this.rep = rep;
        }

        @Override
        public String getID() {
            if (this.id == null) {
                this.id = FactoryManager.makeNullFactoryID(this.rep);
            }
            return this.id;
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = FactoryManager.makeNullFactoryName(this.rep);
            }
            return this.name;
        }

        @Override
        public String getDescription() {
            if (this.desc == null) {
                this.desc = FactoryManager.makeNullFactoryDesc(this.rep);
            }
            return this.desc;
        }

        @Override
        public IDescFactory create() {
            NullDescFactory factory = new NullDescFactory(this.rep);
            factory.setID(this.getID());
            factory.setName(this.getName());
            factory.setDescription(this.getDescription());
            return factory;
        }

        @Override
        public IDescFactory create(IConfiguration configuration) {
            return this.create();
        }

        @Override
        public IConfigDescriptor getConfigurationDescriptor() {
            return null;
        }

        @Override
        public IConfigurationElement getConfigurationElement() {
            return null;
        }

        @Override
        public String getClassAttribute() {
            return null;
        }

        @Override
        public Class<? extends IDescFactory> getCreatableClass() {
            return NullDescFactory.class;
        }
    }
}

