/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.desc;

import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.mappers.IValueMapper;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentMapper
implements IValueMapper<ISegment>,
IHasRep {
    private final IDescSet descs;
    private final IRep rep;
    private final IStoryData data;
    private final boolean longForm;

    public SegmentMapper(IRep rep, IStoryData data) {
        this(rep, data, true);
    }

    public SegmentMapper(IRep rep, IStoryData data, boolean longForm) {
        if (rep == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        this.rep = rep;
        this.data = data;
        this.descs = data.getDescriptions(rep);
        this.longForm = longForm;
    }

    @Override
    public IRep getRep() {
        return this.descs.getRep();
    }

    @Override
    public String serialize(Collection<? extends ISegment> segments) {
        return SegmentMapper.serializeStatic(segments, this.longForm);
    }

    @Override
    public List<ISegment> reconstitute(String value) {
        List<String> blocks = BlockMapper.COMMA.reconstitute(value);
        ArrayList<ISegment> result = new ArrayList<ISegment>(blocks.size());
        for (String block : blocks) {
            result.add(Segment.reconstitute(block.trim(), this.rep, this.data));
        }
        return result;
    }

    public static String serializeStatic(Collection<? extends ISegment> segments) {
        return SegmentMapper.serializeStatic(segments, true);
    }

    public static String serializeStatic(Collection<? extends ISegment> segments, boolean longForm) {
        if (segments == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<? extends ISegment> i = segments.iterator();
        while (i.hasNext()) {
            if (longForm) {
                Segment.serializeLong(i.next(), sb);
            } else {
                Segment.serializeShort(i.next(), sb);
            }
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

