/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.problems;

import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonMatchingTagProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.event.problem.nonmatchingTag";

    public NonMatchingTagProblem(IDesc desc, String buildRuleID) {
        this(Collections.singleton(desc), buildRuleID);
    }

    public NonMatchingTagProblem(Collection<? extends IDesc> problems, String buildRuleID) {
        super(EventRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("non matching pos tag");
        this.setSeverity(2);
        this.setDescs(problems);
        IDescSet ds = this.getDescs().getDescriptions(EventRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)ds.first());
        StringBuilder sb = new StringBuilder();
        if (ds.size() == 1) {
            IEvent e = (IEvent)((IDesc)ds.first()).getData();
            sb.append("The event '");
            sb.append(e.getEventTokens().getDisplayText());
            sb.append("' has no head token with a part of speech that matches that of the event, ");
            sb.append(e.getPOS().getName());
        } else {
            sb.append("There are ");
            sb.append(Integer.toString(ds.size()));
            sb.append(" events whose head tokens do not have a part of speech that matches that of the event (only first shown)");
        }
        this.setDescription(sb.toString());
    }
}

