/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.context.model;

import edu.mit.discourse.core.rep.refexp.RefExpRep;
import edu.mit.semantics.core.rep.context.ContextArg;
import edu.mit.semantics.core.rep.context.IContextArg;
import edu.mit.semantics.core.rep.context.IContextRole;
import edu.mit.semantics.core.rep.context.model.IContextRelArgModel;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;
import org.eclipse.jface.dialogs.IMessageProvider;

public class ContextRelArgModel
extends DescModel
implements IContextRelArgModel {
    private IContextArg loaded = null;
    private int group = this.getDefaultGroup();
    private IContextRole role = this.getDefaultRole();
    private int depth = this.getDefaultDepth();

    public ContextRelArgModel(IStoryModel model) {
        super(model, new IRep[]{EventRep.getInstance(), RefExpRep.getInstance()});
    }

    public IContextArg getLoaded() {
        return this.loaded;
    }

    public void load(IContextArg arg) {
        if (arg == null) {
            this.clear();
            return;
        }
        this.internalClear();
        this.loaded = arg;
        this.role = arg.getRole();
        this.depth = arg.getDepth();
        this.group = arg.getExclusionGroup();
        this.setDesc(arg.getFiller());
    }

    public void setRole(IContextRole newRole) {
        if (newRole == this.role) {
            return;
        }
        this.role = newRole;
        this.fireChanged();
    }

    public int getExclusionGroup() {
        return this.group;
    }

    public IContextRole getRole() {
        return this.role;
    }

    public IDesc getFiller() {
        return this.getDesc();
    }

    public int getDepth() {
        return this.depth;
    }

    public IHasPosition calculatePosition() {
        return this.getDesc();
    }

    public void setExclusionGroup(int group) {
        if (this.group == group) {
            return;
        }
        this.group = group;
        this.fireChanged();
    }

    public void setDepth(int depth) {
        if (this.depth == depth) {
            return;
        }
        this.depth = depth;
        this.fireChanged();
    }

    public IHasPosition getDisplayPosition() {
        return this.getDesc();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (this.role != this.getDefaultRole()) {
            return false;
        }
        if (this.group != this.getDefaultGroup()) {
            return false;
        }
        if (this.depth != this.getDefaultDepth()) {
            return false;
        }
        return super.isCleared();
    }

    protected IMessageProvider calculateMessage() {
        if (this.getRole() == IContextRole.UNKNOWN) {
            return new Message("Please select a role", 3);
        }
        return super.calculateMessage();
    }

    protected void internalClear() {
        this.loaded = null;
        this.group = this.getDefaultGroup();
        this.role = this.getDefaultRole();
        this.depth = this.getDefaultDepth();
        super.internalClear();
    }

    protected IContextRole getDefaultRole() {
        return IContextRole.UNKNOWN;
    }

    protected int getDefaultGroup() {
        return 0;
    }

    protected int getDefaultDepth() {
        return 0;
    }

    public IContextArg create() {
        return new ContextArg(this.group, this.role, this.getDesc(), this.depth);
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }
}

