/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.handlers;

import edu.mit.jverbnet.index.IVerbIndex;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.SemanticsPlugin;
import edu.mit.semantics.core.verbnet.IWorkbenchVerbIndex;
import edu.mit.semantics.ui.dialogs.VerbClassSelectionDialog;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.text.TextRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class BrowseVerbnetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String text = this.getSelectedText(event);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchVerbIndex index = SemanticsPlugin.getDefault().getVerbnetManager().getLatestIndex();
        VerbClassSelectionDialog.selectVerbClass(shell, (IVerbIndex)index, null, text);
        return null;
    }

    protected String getSelectedText(ExecutionEvent event) {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(part instanceof IStoryEditor)) {
            return null;
        }
        IHasPosition p = null;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof TextSelection) {
            TextSelection tsel = (TextSelection)sel;
            p = new SimplePosition(tsel.getOffset(), tsel.getLength());
        } else if (sel instanceof IStructuredSelection) {
            p = (IHasPosition)SelectionUtils.extractSingle((ISelection)sel, IHasPosition.class);
        }
        if (p == null) {
            return null;
        }
        IStoryEditor editor = (IStoryEditor)part;
        IStoryData data = editor.getStoryModel().getData();
        if (data.supports(TokenRep.getInstance())) {
            IDescSet tokens = data.getDescriptions(TokenRep.getInstance()).closedSet(p);
            if (tokens.isEmpty()) {
                tokens = data.getDescriptions(TokenRep.getInstance()).openSet(p);
            }
            StringBuilder sb = new StringBuilder();
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                IToken token = (IToken)((IDesc)i.next()).getData();
                sb.append(token.getSurface());
                if (!token.isFollowedByBreak() || !i.hasNext()) continue;
                sb.append(' ');
            }
            return sb.toString();
        }
        return TextRep.getPrettyText((IHasPosition)p, (IStoryData)data);
    }
}

