/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.actions;

import edu.mit.semantics.core.rep.valence.EventValence;
import edu.mit.semantics.core.rep.valence.IEventValence;
import edu.mit.semantics.core.rep.valence.Valence;
import edu.mit.semantics.core.rep.valence.ValenceRep;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.ActionGroup;

public class ChangeEventValenceFeatureActionGroup
extends ActionGroup {
    private IMenuManager valenceMenu;

    public ChangeEventValenceFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider) {
        this(editor, provider, true);
    }

    public ChangeEventValenceFeatureActionGroup(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.createActions(editor, provider, allMenus);
    }

    public IRep getRep() {
        return ValenceRep.getInstance();
    }

    protected void createActions(IStoryEditor editor, ISelectionProvider provider, boolean allMenus) {
        this.valenceMenu = new MenuManager("&Valence");
        this.valenceMenu.setRemoveAllWhenShown(true);
        this.valenceMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Valence[] valenceArray = Valence.values();
                int n = valenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Valence v = valenceArray[n2];
                    manager.add((IAction)new ChangeValenceAction(v, editor, provider));
                    ++n2;
                }
            }
        });
        if (!allMenus) {
            return;
        }
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        boolean all = obj instanceof IEventValence;
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (all || obj instanceof Valence) {
            menu.appendToGroup("additions", (IContributionItem)this.valenceMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;
        private ISelectionProvider provider;

        public ChangeFeatureAction(F feature, IStoryEditor editor, ISelectionProvider provider) {
            super(ChangeEventValenceFeatureActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            if (provider == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
            this.provider = provider;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangeEventValenceFeatureActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)this.provider.getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof IEventValence) {
                return this.isChecked((IEventValence)element);
            }
            return false;
        }

        protected abstract boolean isChecked(IEventValence var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            IEventValence newEvent = this.createEvent((IEventValence)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newEvent.calculatePosition(), (IData)newEvent, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract IEventValence createEvent(IEventValence var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeValenceAction
    extends ChangeFeatureAction<Valence> {
        public ChangeValenceAction(Valence valence, IStoryEditor editor, ISelectionProvider provider) {
            super(valence, editor, provider);
        }

        @Override
        protected boolean isChecked(IEventValence e) {
            return e.getValence() == this.getFeature();
        }

        @Override
        protected IEventValence createEvent(IEventValence oldEvent) {
            return new EventValence((Valence)this.getFeature(), oldEvent.getEvent());
        }
    }
}

