/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.br;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.br.BrazilianStemmer;

public final class BrazilianStemFilter
extends TokenFilter {
    private Token token = null;
    private BrazilianStemmer stemmer = new BrazilianStemmer();
    private Set exclusions = null;

    public BrazilianStemFilter(TokenStream in) {
        super(in);
    }

    public BrazilianStemFilter(TokenStream in, Hashtable exclusiontable) {
        this(in);
        this.exclusions = new HashSet(exclusiontable.keySet());
    }

    public BrazilianStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (s != null && !s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }
}

