/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public abstract class RemoteResource
extends CachedResourceVariant
implements ISVNRemoteResource {
    protected RemoteFolder parent;
    protected SVNUrl url;
    protected ISVNRepositoryLocation repository;
    protected SVNRevision revision;
    protected SVNRevision.Number lastChangedRevision;
    protected Date date;
    protected String author;
    protected SVNRevision pegRevision;

    public RemoteResource(IResource local, byte[] bytes) {
        String nfo = new String(bytes);
        this.lastChangedRevision = new SVNRevision.Number(Long.parseLong(nfo));
        this.revision = this.lastChangedRevision;
        ISVNLocalResource res = SVNWorkspaceRoot.getSVNResourceFor(local);
        this.url = res.getUrl();
        this.repository = res.getRepository();
    }

    public RemoteResource(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        this.parent = parent;
        this.repository = repository;
        this.url = url;
        this.revision = revision;
        this.lastChangedRevision = lastChangedRevision;
        this.date = date;
        this.author = author;
    }

    public RemoteResource(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        this.parent = null;
        this.repository = repository;
        this.url = url;
        this.revision = revision;
        this.lastChangedRevision = null;
        this.date = null;
        this.author = null;
    }

    public String getName() {
        return this.url != null ? this.url.getLastPathSegment() : "";
    }

    public String getRepositoryRelativePath() {
        return SVNUrlUtils.getRelativePath((SVNUrl)this.getRepository().getUrl(), (SVNUrl)this.getUrl(), (boolean)true);
    }

    public String getProjectRelativePath() {
        ISVNRemoteResource project = this;
        while (project.getParent() != null) {
            project = project.getParent();
        }
        return SVNUrlUtils.getRelativePath((SVNUrl)project.getUrl(), (SVNUrl)this.getUrl(), (boolean)false);
    }

    public boolean exists(IProgressMonitor monitor) throws TeamException {
        return this.parent.exists(this, monitor);
    }

    public ISVNRemoteFolder getParent() {
        return this.parent;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteResource)) {
            return false;
        }
        RemoteResource remote = (RemoteResource)target;
        return remote.isContainer() == this.isContainer() && remote.getUrl().equals((Object)this.getUrl()) && remote.getRevision() == this.getRevision();
    }

    public int hashCode() {
        return this.getUrl().hashCode() + this.getRevision().hashCode();
    }

    public ISVNRepositoryLocation getRepository() {
        return this.repository;
    }

    public SVNUrl getUrl() {
        return this.url;
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public SVNRevision getRevision() {
        return this.revision;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }

    public SVNRevision getPegRevision() {
        return this.pegRevision;
    }

    public void setPegRevision(SVNRevision pegRevision) {
        this.pegRevision = pegRevision;
    }

    public String getContentIdentifier() {
        if (this.getLastChangedRevision() == null) {
            if (this.revision == null) {
                return "";
            }
            return this.revision.toString();
        }
        return String.valueOf(this.getLastChangedRevision().getNumber());
    }

    protected String getCachePath() {
        return String.valueOf(this.getUrl().toString()) + ":" + this.getContentIdentifier();
    }

    protected String getCacheId() {
        return "org.tigris.subversion.subclipse.core";
    }

    public byte[] asBytes() {
        return new Long(this.getContentIdentifier()).toString().getBytes();
    }

    public IResource getResource() {
        return null;
    }

    public ISVNLogMessage[] getLogMessages(SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws TeamException {
        try {
            return this.repository.getSVNClient().getLogMessages(this.getUrl(), pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions);
        }
        catch (SVNClientException e) {
            throw new TeamException("Failed in RemoteResource.getLogMessages()", (Throwable)e);
        }
    }

    public String toString() {
        return this.getCachePath();
    }
}

