/* Filename: OneIndicationPerRefRule.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 27, 2010
 */
package edu.mit.discourse.core.rep.refprops.rules;

import java.util.HashSet;
import java.util.Set;

import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.problems.UnknownPropertyTypeProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class NoUnknownPropertyTypesRule extends AbstractBuildRule {
	
	public static final String ID = NoUnknownPropertyTypesRule.class.getCanonicalName();
	
	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public NoUnknownPropertyTypesRule() {
		super(RefPropRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		IDescSet propDescs = model.getData().getDescriptions(RefPropRep.getInstance());
		Set<IDesc> unknown = new HashSet<IDesc>();
		
		IReferentProperty prop;
		for(IDesc propDesc : propDescs){
			prop = (IReferentProperty)propDesc.getData();
			if(prop.getType() == PropertyType.UNKNOWN)
				unknown.add(propDesc);
		}
		
		if(unknown.isEmpty())
			return null;
		
		
		// do problems
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		for(IDesc propDesc : unknown)
			result.add(new UnknownPropertyTypeProblem(propDesc, getID()));
		return result;
	}

}
















