/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.PlanStatusHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StaticContentProvider;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.query.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public abstract class ProfileModificationWizardPage
extends WizardPage {
    private static final int DEFAULT_HEIGHT = 15;
    private static final int DEFAULT_WIDTH = 120;
    private static final int DEFAULT_DESCRIPTION_HEIGHT = 4;
    private static final int DEFAULT_COLUMN_WIDTH = 60;
    private static final int DEFAULT_SMALL_COLUMN_WIDTH = 20;
    private static final String NESTING_INDENT = "  ";
    private static final IStatus NULL_PLAN_STATUS = new Status(4, "org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, null);
    private IInstallableUnit[] ius;
    ProvisioningPlan currentPlan;
    IStatus currentStatus;
    private String profileId;
    CheckboxTableViewer listViewer;
    Text detailsArea;
    StaticContentProvider contentProvider;
    protected Display display;
    static /* synthetic */ Class class$0;

    protected ProfileModificationWizardPage(String id, IInstallableUnit[] ius, String profileID, ProvisioningPlan initialPlan) {
        super(id);
        this.ius = ius;
        this.profileId = profileID;
        this.currentPlan = initialPlan;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        SashForm sashForm = new SashForm(parent, 512);
        FillLayout layout = new FillLayout();
        sashForm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        sashForm.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)sashForm);
        Composite composite = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(15);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        Table table = this.listViewer.getTable();
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        IUColumnConfig[] columns = this.getColumnConfig();
        int i = 0;
        while (i < columns.length) {
            TableColumn tc = new TableColumn(table, 16384, i);
            tc.setResizable(true);
            tc.setText(columns[i].columnTitle);
            if (columns[i].columnField == 3) {
                tc.setAlignment(131072);
                tc.setWidth(this.convertWidthInCharsToPixels(20));
            } else {
                tc.setWidth(this.convertWidthInCharsToPixels(60));
            }
            ++i;
        }
        ArrayList list = new ArrayList(this.ius.length);
        this.makeElements(this.getIUs(), list);
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProfileModificationWizardPage.this.checkedIUsChanged();
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileModificationWizardPage.this.updateStatus();
            }
        });
        this.listViewer.setComparator((ViewerComparator)new IUComparator(0));
        this.listViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.contentProvider = new StaticContentProvider(list.toArray());
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.setInput(new Object());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new IUDetailsLabelProvider(null, this.getColumnConfig(), this.getShell()));
        this.setInitialCheckState();
        if (this.currentPlan == null) {
            this.checkedIUsChanged();
        } else {
            this.currentStatus = PlanStatusHelper.computeStatus(this.currentPlan, this.ius);
        }
        this.createSizingInfo(composite);
        Group group = new Group((Composite)sashForm, 0);
        group.setText(ProvUIMessages.ProfileModificationWizardPage_DetailsLabel);
        group.setLayout((Layout)new GridLayout());
        this.createDetailsArea((Composite)group);
        this.updateStatus();
        this.setControl((Control)sashForm);
        sashForm.setWeights(new int[]{80, 20});
        Dialog.applyDialogFont((Control)sashForm);
    }

    protected void createSizingInfo(Composite parent) {
    }

    protected void createDetailsArea(Composite parent) {
        this.detailsArea = new Text(parent, 842);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(4);
        data.widthHint = this.convertWidthInCharsToPixels(120);
        this.detailsArea.setLayoutData((Object)data);
    }

    protected void makeElements(IInstallableUnit[] iusToShow, List list) {
        int i = 0;
        while (i < iusToShow.length) {
            list.add(new AvailableIUElement(iusToShow[i], this.getProfileId()));
            ++i;
        }
    }

    public boolean performFinish() {
        if (this.currentStatus != null && this.currentStatus.getSeverity() != 4) {
            ProfileModificationOperation op = this.createProfileModificationOperation(this.currentPlan);
            ProvisioningOperationRunner.schedule(op, this.getShell(), 3);
            return true;
        }
        return false;
    }

    protected Object[] getCheckedElements() {
        return this.listViewer.getCheckedElements();
    }

    protected Object[] getSelectedElements() {
        return ((IStructuredSelection)this.listViewer.getSelection()).toArray();
    }

    protected IInstallableUnit[] elementsToIUs(Object[] elements) {
        IInstallableUnit[] theIUs = new IInstallableUnit[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            theIUs[i] = (IInstallableUnit)ProvUI.getAdapter(object, clazz);
            ++i;
        }
        return theIUs;
    }

    protected IInstallableUnit getSelectedIU() {
        IInstallableUnit[] units = this.elementsToIUs(this.getSelectedElements());
        if (units.length == 0) {
            return null;
        }
        return units[0];
    }

    protected String getProfileId() {
        return this.profileId;
    }

    protected IInstallableUnit[] getIUs() {
        return this.ius;
    }

    protected IUColumnConfig[] getColumnConfig() {
        return ProvUI.getIUColumnConfig();
    }

    protected void checkedIUsChanged() {
        try {
            final Object[] selections = this.getCheckedElements();
            if (selections.length == 0) {
                this.currentPlan = null;
                this.currentStatus = new Status(4, "org.eclipse.equinox.p2.ui", 10006, ProvUIMessages.ProfileModificationWizardPage_NothingSelected, null);
            } else {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            ProfileModificationWizardPage.this.currentPlan = ProfileModificationWizardPage.this.computeProvisioningPlan(selections, monitor);
                            ProfileModificationWizardPage.this.currentStatus = ProfileModificationWizardPage.this.currentPlan != null ? PlanStatusHelper.computeStatus(ProfileModificationWizardPage.this.currentPlan, ProfileModificationWizardPage.this.elementsToIUs(selections)) : NULL_PLAN_STATUS;
                        }
                        catch (ProvisionException e) {
                            ProfileModificationWizardPage.this.currentPlan = null;
                            ProfileModificationWizardPage.this.currentStatus = ProvUI.handleException(e.getCause(), ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, 1);
                        }
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.currentPlan = null;
            this.currentStatus = ProvUI.handleException(e.getCause(), ProvUIMessages.ProfileModificationWizardPage_UnexpectedError, 1);
        }
        this.updateStatus();
    }

    private ProfileModificationOperation createProfileModificationOperation(ProvisioningPlan plan) {
        return new ProfileModificationOperation(this.getOperationLabel(), this.profileId, plan);
    }

    protected abstract ProvisioningPlan computeProvisioningPlan(Object[] var1, IProgressMonitor var2) throws ProvisionException;

    protected void setInitialCheckState() {
        this.listViewer.setAllChecked(true);
    }

    protected ProvisioningContext getProvisioningContext() {
        return new ProvisioningContext();
    }

    protected abstract String getOperationLabel();

    void updateStatus() {
        int messageType = 0;
        boolean pageComplete = true;
        if (this.currentStatus != null && !this.currentStatus.isOK()) {
            messageType = 1;
            int severity = this.currentStatus.getSeverity();
            if (severity == 4) {
                messageType = 3;
                pageComplete = false;
                if (this.currentStatus.getCode() != 10006) {
                    ProvUI.reportStatus(this.currentStatus, 1);
                }
            } else if (severity == 2) {
                messageType = 2;
                ProvUI.reportStatus(this.currentStatus, 1);
            }
        }
        this.setPageComplete(pageComplete);
        this.setMessage(this.getMessageText(), messageType);
        this.detailsArea.setText(this.getDetailText());
    }

    String getDetailText() {
        String detail = "";
        if (this.currentStatus == null || this.currentStatus.isOK()) {
            IInstallableUnit iu = this.getSelectedIU();
            if (iu != null) {
                detail = this.getIUDescription(iu);
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            this.appendDetailText(this.currentStatus, buffer, -1, false);
            detail = buffer.toString();
        }
        return detail;
    }

    void appendDetailText(IStatus status, StringBuffer buffer, int indent, boolean includeTopLevel) {
        block6: {
            block3: {
                Throwable t;
                block4: {
                    block5: {
                        int i = 0;
                        while (i < indent) {
                            buffer.append(NESTING_INDENT);
                            ++i;
                        }
                        if (includeTopLevel && status.getMessage() != null) {
                            buffer.append(status.getMessage());
                        }
                        if ((t = status.getException()) == null) break block3;
                        if (!(t instanceof CoreException)) break block4;
                        IStatus exceptionStatus = ((CoreException)t).getStatus();
                        if (exceptionStatus == null || exceptionStatus.getMessage() == null) break block5;
                        buffer.append(exceptionStatus.getMessage());
                        break block6;
                    }
                    String details = t.getLocalizedMessage();
                    if (details == null) break block6;
                    buffer.append(details);
                    break block6;
                }
                String details = t.getLocalizedMessage();
                if (details == null) break block6;
                buffer.append(details);
                break block6;
            }
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDetailText(children[i], buffer, indent + 1, true);
                buffer.append('\n');
                ++i;
            }
        }
    }

    String getMessageText() {
        if (this.currentStatus == null || this.currentStatus.isOK()) {
            return this.getDescription();
        }
        return this.currentStatus.getMessage();
    }

    protected String getIUDescription(IInstallableUnit iu) {
        String description = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.description");
        if (description == null) {
            description = "";
        }
        return description;
    }
}

