/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag.tagset.models;

import com.google.common.collect.HashMultiset;
import edu.mit.parsing.core.rep.tag.tagset.ITag;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagModel;
import edu.mit.parsing.core.rep.tag.tagset.models.ITagsetModel;
import edu.mit.parsing.core.rep.tag.tagset.models.TagModel;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.INotifyingMessageProvider;
import edu.mit.story.core.notify.MessageProviderManager;
import edu.mit.story.core.notify.NotifyingList;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.XMLUtils;
import edu.mit.story.core.validation.Message;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsetModel
extends AbstractViewModel
implements ITagsetModel,
ChangeListener {
    MessageProviderManager tagModelManager = new MessageProviderManager((ChangeListener)this);
    private String id = null;
    private String name = null;
    private String desc = null;
    private IRep target = null;
    private ITagset.Scope scope = ITagset.Scope.single;
    private Document xmlDoc = null;
    private final List<ITagModel> modelList = new NotifyingList((INotifyCollectionCallback)new INotifyCollectionCallback<ITagModel>(){

        public void elementAdded(ITagModel m) {
            m.setTagSet(TagsetModel.this);
            TagsetModel.this.tagModelManager.add((INotifyingMessageProvider)m);
        }

        public void elementRemoved(ITagModel m) {
            Node parent;
            TagsetModel.this.tagModelManager.remove((INotifyingMessageProvider)m);
            m.setTagSet(null);
            Element e = m.getElement();
            if (e != null && TagsetModel.this.xmlDoc != null && (parent = e.getParentNode()) != null) {
                parent.removeChild(e);
            }
        }
    });

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChanged();
    }

    protected void internalClear() {
        this.setID(null);
        this.setName(null);
        this.setDescription(null);
        this.setScope(null);
        this.setTarget(null);
        this.modelList.clear();
    }

    public boolean isCleared() {
        if (!this.modelList.isEmpty()) {
            return false;
        }
        if (this.id != null) {
            return false;
        }
        if (this.name != null) {
            return false;
        }
        if (this.desc != null) {
            return false;
        }
        if (this.target != null) {
            return false;
        }
        return this.scope == ITagset.Scope.single;
    }

    protected IMessageProvider calculateMessage() {
        if (this.modelList.isEmpty()) {
            return new Message("A tag set must have at least one tag", 3);
        }
        if (this.name == null) {
            return new Message("A tag set must have a name", 3);
        }
        if (this.target == null) {
            return new Message("A tag set must have a target", 3);
        }
        HashMultiset ids = HashMultiset.create();
        for (ITagModel m : this.modelList) {
            if (m.getID() == null) continue;
            ids.add((Object)m.getID());
        }
        for (String id : ids.elementSet()) {
            int cnt = ids.count((Object)id);
            if (cnt <= 1) continue;
            return new Message("The tag '" + id + "' is duplicated " + cnt + " times", 3);
        }
        if (this.tagModelManager.getMessageType() > 0) {
            return this.tagModelManager.getFixedMessage();
        }
        return Message.NO_MESSAGE;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    @Override
    public IRep getTarget() {
        return this.target;
    }

    @Override
    public ITagset.Scope getScope() {
        return this.scope;
    }

    @Override
    public ITag getTag(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ITagModel> getTagModels() {
        return this.modelList;
    }

    @Override
    public ITag getDefault() {
        throw new UnsupportedOperationException();
    }

    public void setID(String id) {
        this.id = id;
        if (this.xmlDoc != null) {
            Element e = this.xmlDoc.getDocumentElement();
            if (id == null) {
                e.removeAttribute("id");
            } else {
                e.setAttribute("id", id);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
        if (this.xmlDoc != null) {
            Element e = this.xmlDoc.getDocumentElement();
            if (name == null) {
                e.removeAttribute("name");
            } else {
                e.setAttribute("name", name);
            }
        }
    }

    public void setDescription(String desc) {
        this.desc = desc;
        if (this.xmlDoc != null) {
            Element e = this.xmlDoc.getDocumentElement();
            if (this.name == null) {
                e.removeAttribute("desc");
            } else {
                e.setAttribute("desc", desc);
            }
        }
    }

    @Override
    public void setScope(ITagset.Scope scope) {
        if (scope == null) {
            scope = ITagset.Scope.single;
        }
        this.scope = scope;
        if (this.xmlDoc != null) {
            Element e = this.xmlDoc.getDocumentElement();
            if (scope == null) {
                e.removeAttribute("scope");
            } else {
                e.setAttribute("scope", scope.getID());
            }
        }
    }

    @Override
    public void setTarget(IRep target) {
        this.target = target;
        if (this.xmlDoc != null) {
            Element e = this.xmlDoc.getDocumentElement();
            if (target == null) {
                e.removeAttribute("target");
            } else {
                e.setAttribute("target", target.getID());
            }
        }
    }

    @Override
    public void load(Document xml) {
        this.clear();
        this.xmlDoc = xml;
        Element root = this.xmlDoc.getDocumentElement();
        this.setID(root.getAttribute("id"));
        this.setName(root.getAttribute("name"));
        this.setDescription(root.getAttribute("desc"));
        IRep rep = StoryPlugin.getDefault().getRepManager().getRep(root.getAttribute("target"));
        this.setTarget(rep);
        String scopeName = root.getAttribute("scope").toLowerCase();
        ITagset.Scope scope = scopeName.length() == 0 ? null : ITagset.Scope.valueOf(scopeName);
        this.setScope(scope);
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if ("TAG".equalsIgnoreCase(n.getNodeName()) && n instanceof Element) {
                Element e = (Element)n;
                ITagModel tagModel = this.createNewTag();
                tagModel.load(e);
            }
            ++i;
        }
    }

    @Override
    public Document getUnderlyingXML() {
        if (this.xmlDoc == null) {
            Document doc = XMLUtils.createEmptyDocument((String)"TAGSET");
            Element root = doc.getDocumentElement();
            if (this.id != null) {
                root.setAttribute("id", this.id);
            }
            if (this.name != null) {
                root.setAttribute("name", this.id);
            }
            if (this.desc != null) {
                root.setAttribute("desc", this.id);
            }
            if (this.target != null) {
                root.setAttribute("target", this.target.getID());
            }
            if (this.scope != null) {
                root.setAttribute("scope", this.scope.getID());
            }
            for (ITagModel m : this.modelList) {
                Element e = doc.createElement("TAG");
                e = XMLUtils.putElement((Node)root, (Element)e);
                m.setElement(e);
            }
            this.xmlDoc = doc;
        }
        return this.xmlDoc;
    }

    public ITagModel createNewTag() {
        TagModel model = new TagModel();
        this.modelList.add(model);
        return model;
    }

    @Override
    public boolean add(ITag o) {
        TagModel model = new TagModel();
        model.setID(o.getID());
        model.setName(o.getName());
        model.setDescription(o.getDescription());
        this.modelList.add(model);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ITag> c) {
        boolean result = false;
        for (ITag iTag : c) {
            result |= this.add(iTag);
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.modelList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.modelList.isEmpty();
    }

    @Override
    public Iterator<ITag> iterator() {
        return new Iterator<ITag>(){
            private Iterator<ITagModel> i;
            {
                this.i = TagsetModel.this.modelList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ITag next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                this.i.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.modelList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.modelList.retainAll(c);
    }

    @Override
    public int size() {
        return this.modelList.size();
    }

    @Override
    public Object[] toArray() {
        return this.modelList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.modelList.toArray(a);
    }
}

