/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.InstructionParser;
import org.eclipse.equinox.internal.p2.engine.TouchpointManager;
import org.eclipse.equinox.internal.provisional.p2.engine.EngineSession;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.osgi.util.NLS;

public abstract class InstallableUnitPhase
extends Phase {
    protected static final String PARM_ARTIFACT_REQUESTS = "artifactRequests";
    protected static final String PARM_ARTIFACT = "artifact";
    protected static final String PARM_IU = "iu";
    protected static final String PARM_TOUCHPOINT = "touchpoint";
    protected ProvisioningContext provContext = null;
    private Map touchpointToTouchpointParameters;

    protected InstallableUnitPhase(String phaseId, int weight) {
        super(phaseId, weight);
    }

    void perform(MultiStatus status, EngineSession session, IProfile profile, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        this.provContext = context;
        this.touchpointToTouchpointParameters = new HashMap();
        int i = 0;
        while (i < operands.length) {
            if (operands[i] instanceof InstallableUnitOperand) {
                InstallableUnitOperand iuOperand = (InstallableUnitOperand)operands[i];
                TouchpointType type = InstallableUnitPhase.getTouchpointType(iuOperand);
                Touchpoint touchpoint = TouchpointManager.getInstance().getTouchpoint(type);
                if (touchpoint == null) {
                    status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.required_touchpoint_not_found, (Object)type), null));
                    return;
                }
                if (!this.touchpointToTouchpointParameters.containsKey(touchpoint)) {
                    this.touchpointToTouchpointParameters.put(touchpoint, null);
                }
            }
            ++i;
        }
        super.perform(status, session, profile, operands, context, monitor);
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        InstallableUnitPhase.mergeStatus(status, this.initializeInstallableUnitPhase(monitor, profile, parameters));
        Iterator it = this.touchpointToTouchpointParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Touchpoint touchpoint = (Touchpoint)entry.getKey();
            HashMap<String, Touchpoint> touchpointParameters = new HashMap<String, Touchpoint>(parameters);
            touchpointParameters.put(PARM_TOUCHPOINT, touchpoint);
            InstallableUnitPhase.mergeStatus(status, touchpoint.initializePhase(monitor, profile, this.phaseId, touchpointParameters));
            entry.setValue(touchpointParameters);
        }
        return status;
    }

    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        Iterator it = this.touchpointToTouchpointParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Touchpoint touchpoint = (Touchpoint)entry.getKey();
            Map touchpointParameters = (Map)entry.getValue();
            InstallableUnitPhase.mergeStatus(status, touchpoint.completePhase(monitor, profile, this.phaseId, touchpointParameters));
            entry.setValue(null);
        }
        InstallableUnitPhase.mergeStatus(status, this.completeInstallableUnitPhase(monitor, profile, parameters));
        return status;
    }

    protected IStatus initializeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return null;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        InstallableUnitPhase.mergeStatus(status, this.initializeOperand(profile, iuOperand, parameters, monitor));
        Touchpoint touchpoint = InstallableUnitPhase.getTouchpoint(iuOperand);
        Map touchpointParameters = (Map)this.touchpointToTouchpointParameters.get(touchpoint);
        if (touchpointParameters != null) {
            parameters.putAll(touchpointParameters);
        }
        InstallableUnitPhase.mergeStatus(status, touchpoint.initializeOperand(profile, this.phaseId, iuOperand, parameters));
        return status;
    }

    protected IStatus completeOperand(IProfile profile, Operand operand, Map parameters, IProgressMonitor monitor) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return null;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        Touchpoint touchpoint = InstallableUnitPhase.getTouchpoint(iuOperand);
        InstallableUnitPhase.mergeStatus(status, touchpoint.completeOperand(profile, this.phaseId, iuOperand, parameters));
        InstallableUnitPhase.mergeStatus(status, this.completeOperand(profile, iuOperand, parameters, monitor));
        return status;
    }

    protected ProvisioningAction[] getActions(Operand operand) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return null;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        return this.getActions(iuOperand);
    }

    protected boolean isApplicable(Operand operand) {
        if (!(operand instanceof InstallableUnitOperand)) {
            return false;
        }
        InstallableUnitOperand iuOperand = (InstallableUnitOperand)operand;
        return this.isApplicable(iuOperand);
    }

    protected static final Touchpoint getTouchpoint(InstallableUnitOperand operand) {
        return TouchpointManager.getInstance().getTouchpoint(InstallableUnitPhase.getTouchpointType(operand));
    }

    private static Touchpoint getTouchpoint(IInstallableUnit unit) {
        return TouchpointManager.getInstance().getTouchpoint(unit.getTouchpointType());
    }

    protected static final TouchpointType getTouchpointType(InstallableUnitOperand operand) {
        IInstallableUnit unit = operand.second();
        if (unit == null) {
            unit = operand.first();
        }
        return unit.getTouchpointType();
    }

    protected final ProvisioningAction[] getActions(IInstallableUnit unit, String key) {
        String[] instructions = InstallableUnitPhase.getInstructions(unit, key);
        if (instructions == null || instructions.length == 0) {
            return null;
        }
        Touchpoint touchpoint = InstallableUnitPhase.getTouchpoint(unit);
        if (touchpoint == null) {
            return null;
        }
        InstructionParser parser = new InstructionParser(this, touchpoint);
        ArrayList<ProvisioningAction> actions = new ArrayList<ProvisioningAction>();
        int i = 0;
        while (i < instructions.length) {
            actions.addAll(Arrays.asList(parser.parseActions(instructions[i])));
            ++i;
        }
        return actions.toArray(new ProvisioningAction[actions.size()]);
    }

    private static final String[] getInstructions(IInstallableUnit unit, String key) {
        TouchpointData[] data = unit.getTouchpointData();
        if (data == null) {
            return null;
        }
        String[] matches = new String[data.length];
        int count = 0;
        int i = 0;
        while (i < data.length) {
            matches[count] = data[i].getInstructions(key);
            if (matches[count] != null) {
                ++count;
            }
            ++i;
        }
        if (count == data.length) {
            return matches;
        }
        String[] result = new String[count];
        System.arraycopy(matches, 0, result, 0, count);
        return result;
    }

    public ProvisioningAction getAction(String actionId) {
        return null;
    }

    protected abstract ProvisioningAction[] getActions(InstallableUnitOperand var1);

    protected boolean isApplicable(InstallableUnitOperand operand) {
        return true;
    }

    protected IStatus initializeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        return Status.OK_STATUS;
    }

    protected IStatus completeInstallableUnitPhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        return Status.OK_STATUS;
    }

    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    protected IStatus completeOperand(IProfile profile, InstallableUnitOperand operand, Map parameters, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }
}

